# REMOVE ME (I was set for NMU) and uncomment real Release tags:
Release: alt1.git20140417.2
%define mpiimpl openmpi
%define mpidir %_libexecdir/%mpiimpl
%define somver 0
%define sover %somver.112.26

Name: libflame
Epoch: 1
Version: 5.1.0
#Release: alt1.git20140417
Summary: Formal Linear Algebra Method Environment
License: LGPL v2.1
Group: System/Libraries
Url: http://www.cs.utexas.edu/users/flame/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/flame/libflame.git
Source: %name-%version.tar
#Source1: http://www.cs.utexas.edu/users/flame/book/Downloads/FLAMEC/example.tar.gz
#Source2: elemental.tar.gz

BuildPreReq: gcc-fortran liblapack-devel
BuildPreReq: doxygen /usr/bin/dvips tex(draftcopy.sty)

%description
The objective of the FLAME project is to transform the development of dense
linear algebra libraries from an art reserved for experts to a science that can
be understood by novice and expert alike. Rather than being only a library, the
project encompasses a new notation for expressing algorithms, a methodology for
systematic derivation of algorithms, Application Program Interfaces (APIs) for
representing the algorithms in code, and tools for mechanical derivation,
implementation and analysis of algorithms and implementations.

%package devel
Summary: Development files of Formal Linear Algebra Method Environment
Group: Development/Other
Requires: %name = %EVR
Requires: liblapack-devel

%description devel
The objective of the FLAME project is to transform the development of dense
linear algebra libraries from an art reserved for experts to a science that can
be understood by novice and expert alike. Rather than being only a library, the
project encompasses a new notation for expressing algorithms, a methodology for
systematic derivation of algorithms, Application Program Interfaces (APIs) for
representing the algorithms in code, and tools for mechanical derivation,
implementation and analysis of algorithms and implementations.

This package contains development files dof libflame.

%package doc
Summary: Documentation for Formal Linear Algebra Method Environment
Group: Development/Documentation
BuildArch: noarch

%description doc
The objective of the FLAME project is to transform the development of dense
linear algebra libraries from an art reserved for experts to a science that can
be understood by novice and expert alike. Rather than being only a library, the
project encompasses a new notation for expressing algorithms, a methodology for
systematic derivation of algorithms, Application Program Interfaces (APIs) for
representing the algorithms in code, and tools for mechanical derivation,
implementation and analysis of algorithms and implementations.

This package contains development documentation for FLAME.

%package example
Summary: Example of using Formal Linear Algebra Method Environment
Group: Development/Other
BuildArch: noarch

%description example
The objective of the FLAME project is to transform the development of dense
linear algebra libraries from an art reserved for experts to a science that can
be understood by novice and expert alike. Rather than being only a library, the
project encompasses a new notation for expressing algorithms, a methodology for
systematic derivation of algorithms, Application Program Interfaces (APIs) for
representing the algorithms in code, and tools for mechanical derivation,
implementation and analysis of algorithms and implementations.

This package contains example of using FLAME.

%prep
%setup
#tar -xzf %SOURCE1
#tar -xzf %SOURCE2

sed -i "s|@fla_host_cpu@|%_arch|" build/config.mk.in

sed -i 's|libgoto\.a|libopenblas.so|g' $(find ./ -name makefile)
sed -i 's|libgoto_core2\.a|libopenblas.so|g' $(find ./ -name makefile)
sed -i 's|liblapack\.a|liblapack.so|g' $(find ./ -name makefile)

%build
%add_optflags %optflags_shared -std=gnu99
#autoreconf
./bootstrap
%configure \
	--enable-debug \
	--enable-static-build \
	--enable-dynamic-build \
	--enable-external-lapack-for-subproblems \
	--enable-lapack2flame=no \
	--enable-external-lapack-interfaces \
	--enable-blas3-front-end-cntl-trees \
	--enable-cblas-interfaces \
	--disable-goto-interfaces \
	--disable-gpu \
	--enable-verbose-make-output \
	--enable-multithreading=pthreads \
	--enable-memory-leak-counter \
	--enable-supermatrix \
	--enable-supermatrix-visualization
%make_build HOST=%_host SOMVER=%somver SOVER=%sover

doxygen
pushd docs/libflame
%make_build
popd

%install
%makeinstall_std HOST=%_host INSTALL_PREFIX=%buildroot%prefix \
	 SOMVER=%somver SOVER=%sover

rm -f %buildroot%_includedir
mv %buildroot%prefix/include-%_arch-%version %buildroot%_includedir
%if "%_libexecdir" != "%_libdir"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

install -d %buildroot%_docdir/%name

install -m644 $(find ./ -name '*.pdf') %buildroot%_docdir/%name
mv doxygen/html %buildroot%_docdir/%name/

%files
%doc AUTHORS CHANGELOG CONTRIBUTORS LICENSE KNOWN-ISSUES README
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/*

%files doc
%_docdir/%name

%files example
%doc examples

%changelog
