Name: libgc
Version: 7.6.8
Release: alt1

Summary: The Boehm-Demers-Weiser conservative garbage collector

License: MIT and GPLv2+
Group: System/Libraries
Url: http://www.hboehm.info/gc/

# Source-url: http://www.hboehm.info/gc/gc_source/gc-%version.tar.gz
Source: gc-%version.tar
Patch: gc-aarch64.patch
# https://github.com/ivmai/bdwgc/issues/87
Patch1: libgc-7.6.0-upstream-c++.patch

BuildRequires: gcc-c++
BuildRequires: libatomic_ops-devel-static

%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}

%def_disable static

%description
The Boehm-Demers-Weiser conservative garbage collector can be used as a
garbage collecting replacement for C malloc or C++ new.  Alternatively,
it may be used as a leak detector for C or C++ programs, though that is
not its primary goal.

%package devel
Summary: Development files for libgc
Group: Development/C
Requires: %name = %version-%release

%description devel
The Boehm-Demers-Weiser conservative garbage collector can be used as a
garbage collecting replacement for C malloc or C++ new.  Alternatively,
it may be used as a leak detector for C or C++ programs, though that is
not its primary goal.

This package contains development files for libgc.

%package devel-static
Summary: Static libgc library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libgc library.

%prep
%setup -n gc-%version
#patch -p1
#patch1 -p1

%build
# see bugzilla.redhat.com/689877
export CPPFLAGS='-DUSE_GET_STACKBASE_FOR_MAIN=1 -DUSE_LIBC_PRIVATES=1'
%configure \
	--enable-cplusplus \
	--enable-large-config \
	--enable-threads=posix \
	--with-libatomic-ops=yes \
	--enable-shared=yes \
	%{subst_enable static} \
%ifarch %{ix86}
	--enable-parallel-mark \
%endif
	#
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_man3dir/
install -pm644 doc/gc.man %buildroot%_man3dir/gc.3
rm -rf %buildroot/usr/share/doc/

%check
export LD_LIBRARY_PATH=%buildroot%_libdir:$PWD/.libs
%make_build -k check

%files
%_libdir/*.so.*
%doc ChangeLog README.QUICK README.md doc/README.cords
%doc doc/README.environment

%files devel
%_libdir/*.so
%_includedir/gc/
%_includedir/gc.h
%_includedir/gc_cpp.h
%_pkgconfigdir/bdw-gc.pc
%_man3dir/*
%doc doc/README.linux doc/README.arm.cross doc/README.autoconf doc/README.cmake
%doc doc/*.html

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
