%def_disable snapshot
%def_disable docs

%define _name granite
%define rdn_name io.elementary.%_name
%define ver_major 5.2
%define api_ver 1.0
%define sover 5

Name: libgranite
Version: %ver_major.5
Release: alt1

Summary: Extension of GTK+3 libraries
Group: System/Libraries
License: GPLv3+
Url: https://github.com/elementary/%_name

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
#VCS: https://github.com/elementary/granite.git
Source: %_name-%version.tar
%endif

%define gtk_ver 3.22

BuildRequires(pre): meson rpm-build-gir
BuildRequires: vala-tools libgtk+3-devel >= %gtk_ver libgee0.8-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libgtk+3-gir-devel libgee0.8-gir-devel
%{?_enable_docs:BuildRequires: gtk-doc valadoc}

%description
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains the shared library.

%package devel
Summary: Extension of GTK+ libraries (development files)
Group: Development/GNOME and GTK+

Requires: %name = %version-%release

%description devel
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains header files.

%package vala
Summary: Vala language bindings for the granite library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the granite library.

%package -n granite-demo
Summary: Extension of GTK+ libraries (demo binary)
Group: Development/GNOME and GTK+

Requires: %name = %version-%release

%description -n granite-demo
Granite is an extension of GTK+. Among other things, it provides the
commonly-used widgets such as modeswitchers, welcome screens, AppMenus,
search bars, and more found in elementary apps.

This package contains a small demo application to show Granite Widgets.

%package gir
Summary: GObject introspection data for the granite library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the granite library.

%package gir-devel
Summary: GObject introspection devel data for the granite library.
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the granite library.

%prep
%setup -n %_name-%version

%build
%meson %{?_enable_docs:-Ddocumentation=true}
%meson_build

%install
%meson_install
%find_lang %_name

%files -f %_name.lang
%doc AUTHORS README*
%_libdir/*.so.*

%files devel
%_includedir/%_name/
%_libdir/*.so
%_pkgconfigdir/%_name.pc

%files -n %_name-demo
%_bindir/*
%_desktopdir/%rdn_name.demo.desktop
%_datadir/icons/hicolor/*/*/*.svg

%files gir
%_typelibdir/Granite-%api_ver.typelib

%files gir-devel
%_girdir/Granite-%api_ver.gir

%files vala
%_datadir/vala/vapi/%_name.deps
%_datadir/vala/vapi/%_name.vapi

%changelog
