%define _unpackaged_files_terminate_build 1

%def_disable static

Name: libid3tag
Version: 0.15.1b
Release: alt9
Summary: ID3 Tag manipulation library
Summary(ru_RU.UTF-8): Библиотека для работы с тегами ID3
License: GPL-2.0
Group: Sound
Url: http://mad.sourceforge.net/

# http://download.sourceforge.net/%name/%name-%version.tar.bz2
Source: %name-%version.tar
Patch1: %name-0.15.0b-alt-pkgconfig.patch
Patch2: libid3tag-0.15.1b-fix-CVE-2008-2109.patch

# Patches from Debian
Patch10: 10_a_capella.dpatch
# CVE-2004-2779
Patch11: 10_utf16.dpatch
Patch12: 11_unknown_encoding.dpatch
Patch13: gperf_size_t.patch

# Patches from Gentoo
Patch20: libid3tag-0.15.1b-file-write.patch
Patch21: libid3tag-0.15.1b-tag.patch

%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires: gcc-c++ gperf libstdc++-devel zlib-devel

%description
%name is a library for reading and (eventually) writing ID3 tags,
both ID3v1 and the various versions of ID3v2.

%description -l ru_RU.UTF-8
%name -- это библиотека для чтения и записи тегов ID3v1 и ID3v2.

%package devel
Summary: Development files for %name
Group: Development/C
PreReq: %name = %EVR

%description devel
This package contains development files required for packaging software
using %name library.

%description devel -l ru_RU.UTF-8
В этом пакете находятся файлы, необходимые для использования %name
в разработке приложений.

%package devel-static
Summary: Static libraries for %name
Group: Development/C
PreReq: %name-devel = %EVR

%description devel-static
This package contains development libraries required for packaging
statically linked %name-based software.

%description devel-static -l ru_RU.UTF-8
В этом пакете находятся статические библиотеки, необходимые для
использования %name в разработке статических приложений.

%prep
%setup
%patch1 -p1
%patch2 -p0
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch20 -p1
%patch21 -p1

touch NEWS AUTHORS ChangeLog

%build
%set_libtool_version 1.5
%autoreconf

%configure %{subst_enable static}

# SMP-incompatible build
%make

%install
%makeinstall_std

%files
%doc COPYING
%doc CHANGES README CREDITS COPYRIGHT
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
