%def_enable doc

Summary:          Library to support IDNA2008 internationalized domain names
Name:             libidn2
Version:          2.2.0
Release:          alt1
License:          (GPLv2+ or LGPLv3+) and GPLv3+
Group:            System/Libraries
URL:              https://www.gnu.org/software/libidn/#libidn2
Source0:          %name-%version.tar
BuildRequires:    libunistring-devel
# Needed for autoreconf
BuildRequires: /usr/bin/gtkdocize
%{?_enable_doc:BuildRequires: texinfo ronn groff-base}

Requires: libunistring2 >= 0.9.8-alt1

%define _unpackaged_files_terminate_build 1

%description
Libidn2 is an implementation of the IDNA2008 specifications in RFC
5890, 5891, 5892, 5893 and TR46 for internationalized domain names
(IDN). It is a standalone library, without any dependency on libidn.

%package devel
Summary:          Development files for libidn2
Group:            Development/Other
Requires:         %name = %version-%release

%description devel
The libidn2-devel package contains libraries and header files for
developing applications that use libidn2.

%package -n idn2
Summary:          Libidn2 Internationalized Domain Names conversion tool
Group:            Networking/DNS

%description -n idn2
idn2 tool converts DNS domains from UTF-8 to ASCII compatibile encoding (ACE)
form, as used in the DNS protocol. The encoding format is the Internationalized
Domain Name (IDNA2008/TR46) format.

%prep
%setup
# Workaround for generating idn2.1
rm doc/idn2.1

%build
%autoreconf
%configure \
	--disable-static \
	--disable-silent-rules \
	%{subst_enable doc}

%make_build

%install
%makeinstall_std

# Clean-up examples for documentation
%make_build -C examples distclean
rm -f examples/Makefile*

# Relocate shared libraries from %%_libdir/ to /%%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -fnrs %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%find_lang %name

%check
%make_build -C tests check

%files -f %name.lang
%doc COPYING COPYING.LESSERv3 COPYING.unicode COPYINGv2
%doc AUTHORS NEWS README.md
/%_lib/%name.so.*

%files devel
%doc doc/%name.html examples
%_libdir/%name.so
%_libdir/pkgconfig/%name.pc
%_includedir/*.h
%if_enabled doc
%_man3dir/*
%_datadir/gtk-doc/
%_infodir/%name.info*
%endif

%files -n idn2
%_bindir/idn2
%{?_enable_doc:%_man1dir/idn2.1*}

%changelog
