%define _name nice
%define ver_major 0.1
%define api_ver %ver_major
%define gst_api_ver 1.0

%def_disable static
%def_enable gupnp
%def_with gstreamer
%def_enable gtk_doc
%def_disable check

Name: libnice
Version: %ver_major.16
Release: alt1

Summary: Connectivity Establishment standard (ICE) library
Group: System/Libraries
License: LGPLv2+/MPL
Url: http://nice.freedesktop.org

Source: http://nice.freedesktop.org/releases/%name-%version.tar.gz

%define glib_ver 2.48
%define gi_ver 1.30
%define tls_ver 2.12.0

BuildRequires: glib2-devel >= %glib_ver
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_gupnp:BuildRequires: libgupnp-igd-devel}
%{?_with_gstreamer:BuildRequires: gst-plugins%gst_api_ver-devel}
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libgnutls-devel

%description
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains files needed to develop applications using Nice

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains development documentation for %name.

%package gir
Summary: GObject introspection data for the Nice library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Nice library.

%package gir-devel
Summary: GObject introspection devel data for the Nice library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the Nice library.

%package devel-static
Summary: Static library for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package contains a statically-linked variant of %name

%package -n gst-plugins-nice
Summary: UDP connectivity establishment plugin for Gstreamer based on libnice
Group: System/Libraries
Requires: %name = %version-%release

%description -n gst-plugins-nice
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer

%package -n gst-plugins-nice%gst_api_ver
Summary: UDP connectivity establishment plugin for Gstreamer (1.0) based on libnice
Group: System/Libraries
Requires: %name = %version-%release

%description -n gst-plugins-nice%gst_api_ver
Nice is an implementation of the IETF's draft Interactice Connectivity
Establishment standard (ICE). It provides GLib-based library, libnice.

This package provides Interactive UDP connectivity establishment plugin
for Gstreamer (1.0 API version)

%prep
%setup

%build
%configure \
	%{subst_enable static} \
	%{subst_enable gupnp} \
	%{subst_enable gstreamer} \
	%{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/*.so.*
%doc AUTHORS ChangeLog NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files gir
%_typelibdir/Nice-%api_ver.typelib

%files gir-devel
%_girdir/Nice-%api_ver.gir

%if_with gstreamer
%files -n gst-plugins-nice%gst_api_ver
%_libdir/gstreamer-%gst_api_ver/libgstnice.so
%exclude %_libdir/gstreamer-*/*.la
%endif

# don't package tools
%exclude %_bindir/stun*


%changelog
