%define ver_major 0.7
%def_enable introspection
%def_enable gtk_doc
%def_enable docbook_docs
%def_enable check

Name: libnotify
Version: %ver_major.8
Release: alt1

Summary: Desktop notification library
Group: System/Libraries
License: LGPLv2.1+
Url: http://www.gnome.org

# https://gitlab.gnome.org/GNOME/libnotify.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Provides: %{name}4 = %version-%release
Obsoletes: %{name}4

BuildRequires(pre): meson
BuildRequires: libgio-devel
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_docbook_docs:BuildRequires: xmlto}
%{?_enable_check:BuildRequires: libgtk+3-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}

%description
The library that allows applications post notifications on the desktop
in accordance to the proposed Desktop Notification Specification.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Provides: %{name}4-devel = %version-%release
Obsoletes: %{name}4-devel

%description devel
Files needed to develop applications that use libnotify, a desktop
notification library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version
Provides: %{name}4-devel-doc = %version-%release
Obsoletes: %{name}4-devel-doc

%description devel-doc
API documentation for %name in gtk-doc format.

%package gir
Summary: GObject introspection data for libnotify
Group: System/Libraries
Requires: %name = %version-%release
Provides: %{name}4-gir = %version-%release
Obsoletes: %{name}4-gir

%description gir
GObject introspection data for the desktop notification library.

%package gir-devel
Summary: GObject introspection devel data for libnotify
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release
Provides: %{name}4-gir-devel = %version-%release
Obsoletes: %{name}4-gir-devel

%description gir-devel
GObject introspection devel data for the desktop notification library.

%package -n notify-send
Summary: A program to send desktop notifications
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description -n notify-send
notify-send sends desktop notifications via a notification daemon from
the command line.

%prep
%setup
%patch -p1

%build
%meson \
	%{?_disable_gtk_doc:-Dgtk_doc=false} \
	%{?_disable_docbook_docs:-Ddocbook_docs=false} \
	%{?_disable_introspection:-Dintrospection=disabled} \
	%{?_disable_check:-Dtests=false}
%meson_build

%install
%meson_install

%check
%meson_test

%files
%_libdir/*.so.*
%doc NEWS README

%files -n notify-send
%_bindir/notify-send

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%doc NEWS %{?_enable_docbook_docs:%__builddir/docs/notification-spec.html}

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/Notify-%ver_major.typelib

%files gir-devel
%_girdir/Notify-%ver_major.gir
%endif

%{?_enable_docbook_docs:%exclude %_datadir/doc/%name/}

%changelog
