# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/R boost-devel boost-filesystem-devel boost-program_options-devel
# END SourceDeps(oneline)
%add_optflags %optflags_shared
%define oldname ompl
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This package depends on automagic byte compilation
# https://fedoraproject.org/wiki/Changes/No_more_automagic_Python_bytecompilation_phase_2
%global _python_bytecompile_extra 1

Name:           libompl
Version:        1.3.2
Release:        alt1_6
Summary:        The Open Motion Planning Library

Group:          System/Libraries
License:        BSD
URL:            http://ompl.kavrakilab.org/
Source0:        https://bitbucket.org/%{oldname}/%{oldname}/downloads/%{oldname}-%{version}-Source.tar.gz
BuildRequires:  gcc-c++
BuildRequires:  boost-complete >= 1.42.0
BuildRequires:  ctest cmake
BuildRequires:  doxygen
BuildRequires:  libflann-devel
BuildRequires:  graphviz libgraphviz
BuildRequires:  libode-devel
BuildRequires:  python
BuildRequires:  erb

Patch0: ompl-1.3.2-pybindings.patch
Source44: import.info
Provides: ompl = %{version}-%{release}

%description
The Open Motion Planning Library (OMPL) consists of many state-of-the-art 
sampling-based motion planning algorithms. OMPL itself does not contain 
any code related to, e.g., collision checking or visualization. This is 
a deliberate design choice, so that OMPL is not tied to a particular 
collision checker or visualization front end.

%package        devel
Summary:        Development files for %{oldname}
Group:          Development/Other
Requires:       %{name} = %{version}-%{release}
Requires:       boost-complete
Provides: ompl-devel = %{version}-%{release}

%description    devel
The %{oldname}-devel package contains libraries and header files for
developing applications that use %{oldname}.


%prep
%setup -q -n %{oldname}-%{version}-Source
# Get rid of bundled odeint
rm -rf src/external/omplext_odeint/
%patch0 -p0 -b .pybindings

%build
# Python bindings are disabled because dependencies pygccxml and pyplusplus are not packaged for Fedora
mkdir build
cd build
%{fedora_cmake} -DCMAKE_SKIP_RPATH=ON \
  -DOMPL_BUILD_PYBINDINGS=OFF \
  -DOMPL_LIB_INSTALL_DIR=%{_lib} \
  -DBOOST_LIBRARYDIR=%{_libdir} \
  -DODE_LIB_PATH=%{_libdir} \
  -DBUILD_OMPL_TESTS=ON  \
  -DOMPL_ODESOLVER=ON \
  -DOMPL_REGISTRATION=OFF ..

%make_build
make doc
rm -f doc/html/installdox

%install
make -C build install DESTDIR=%{buildroot}

rm -f %{buildroot}%{_datadir}/%{oldname}/demos/*.py
rm -rf %{buildroot}%{_includedir}/%{oldname}/CMakeFiles
rm -rf %{buildroot}%{_bindir}

%check
export LD_LIBRARY_PATH=%{buildroot}%{_libdir}
make -C build test || exit 0




%files
%doc LICENSE README.md
%{_libdir}/libompl.so.*
%{_mandir}/man1/*.1*

%files devel
%doc doc/html
%{_libdir}/libompl.so
%{_includedir}/%{oldname}
%{_datadir}/%{oldname}
%{_libdir}/pkgconfig/*.pc
%{_libdir}/cmake/%{oldname}

%changelog
