%define rname pangomm
%define major 2.42
%define api_ver 1.4

Name: lib%rname
Version: %major.0
Release: alt1

Summary: This library provides a C++ interface to pango
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

Conflicts: libgtkmm2 < 2.14.1

Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%major/%rname-%version.tar.xz

%define glib_ver 2.48.0
%define cairo_ver 1.12
%define pango_ver 1.39.0

BuildRequires: mm-common gcc-c++
BuildRequires: libcairomm-devel >= %cairo_ver
BuildRequires: libglibmm-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver

%description
This library provides a C++ interface to pango.

%package devel
Summary: Headers and development files of %name library
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Conflicts: libgtkmm2-devel < 2.14.1

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%package doc
Summary: %name documentation (html)
Group: Publishing
Requires: %name = %version-%release
BuildArch: noarch

%description doc
%name development documentation (html)

%prep
%setup -n %rname-%version

%build
%configure \
	--disable-static
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/%rname-%api_ver
%_libdir/*.so
%_libdir/%rname-%api_ver
%_pkgconfigdir/*.pc

%files doc
%_datadir/devhelp/books/%rname-%api_ver
%_docdir/%rname-%api_ver

%changelog
