%define _name libqmi
%define _libexecdir %prefix/libexec

Name: %_name-glib
Version: 1.24.14
Release: alt1

Summary: QMI modem protocol helper library
License: LGPLv2+
Group: System/Libraries
URL: https://cgit.freedesktop.org/libqmi
Vcs: git://anongit.freedesktop.org/libqmi
Source: %name-%version.tar

Patch: %_name-%version-%release.patch

BuildRequires: glib2-devel libgio-devel
BuildRequires: libmbim-glib-devel >= 1.18.0
BuildRequires: libgudev-devel
BuildRequires: python-modules-json
BuildRequires: gtk-doc help2man

%define _unpackaged_files_terminate_build 1

%description
libqmi is a glib-based library for talking to WWAN modems and devices
which speak the Qualcomm MSM Interface (QMI) protocol.

%package utils
Summary: QMI command line utilities
License: GPLv2+
Group: System/Base
Requires: %name = %version-%release

%description utils
QMI command line utilities

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: glib2-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: This package contains development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: %name-devel = %version-%release

%description devel-doc
This package contains development documentation for %name

%prep
%setup
%patch -p1
touch README ChangeLog

%build
%ifarch %e2k
%define more_warnings no
%else
%define more_warnings error
%endif

%autoreconf
%configure \
	--disable-static \
	--enable-mbim-qmux \
	--enable-firmware-update \
	--with-udev \
	--enable-gtk-doc \
	--enable-more-warnings=%more_warnings
%make_build

# Fix names in the man pages
sed -i 's;lt\\-qmicli;qmicli;' docs/man/qmicli.1
sed -i -r 's;lt\\-(qmi\\-firmware\\-update);\1;' docs/man/qmi-firmware-update.1

%install
%makeinstall_std

%check
make check

%files
%_libdir/*.so.*
%_libexecdir/qmi-proxy

%files utils
%_bindir/*
%_man1dir/qmi*.1*
%_datadir/bash-completion/completions/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*


%changelog
