Name:     librecad
Version:  2.2.0
Release:  alt0.2.rc1

Summary:  Computer-aided design (CAD) system
Packager: Andrey Cherepanov <cas@altlinux.org>

Url: 	  http://www.librecad.org
License:  GPLv2
Group:    Graphics

Source:   librecad-%version.tar
Patch0:    0001-Adding-DXF-.desktop-file.patch
Patch1:   librecad-fix-desktop.patch
Patch2:   librecad-fix-build-with-qt5.11.patch
Patch3:   librecad-fix-build-with-qt5.15.patch

Requires: librecad-data

BuildRequires: boost-devel-headers gcc-c++
BuildRequires: libmuparser-devel
BuildRequires: libfreetype-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-sql-mysql qt5-sql-odbc qt5-sql-postgresql
BuildRequires: qt5-tools

%description
LibreCAD is an application for computer aided design (CAD) in two
dimensions (2D). With LibreCAD you can create technical drawings
such as plans for buildings, interiors, mechanical parts or schemas
and diagrams.

%package data
Group: Graphics
Summary: Platform independent files for %name
Requires: %name
BuildArch: noarch

%description data
Contains the platform-independent files for LibreCAD, including
fonts, patterns, translations.

#package doc
#Group:		Graphics
#Summary:	Documentation for %name
#Requires:	%name
#BuildArch:	noarch
#
#description doc
#Documentation for %name, a Qt4 application to design 2D CAD
#drawing based on the community edition of QCad.

%package plugins
Group: Graphics
Summary: Plugins libraries files for %name
Requires: %name

%description plugins
Contains the plugins files for LibreCAD.

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
find . -type f -executable -a \( -name '*.cpp' -o -name '*.h' \) | xargs -i{} chmod 644 {}

%build
export PATH=%_qt5_bindir:$PATH
%qmake_qt5 librecad.pro
%make_build

pushd plugins
	%qmake_qt5
	%make_build plugins.pro
popd

%install
%makeinstall INSTALL_ROOT=%buildroot

install -m 755 -d %buildroot%_datadir/%name/doc
install -m 755 -d %buildroot%_datadir/%name/fonts
install -m 755 -d %buildroot%_datadir/%name/library
install -m 755 -d %buildroot%_datadir/%name/patterns
install -m 755 -d %buildroot%_datadir/%name/qm
install -m 755 -d %buildroot%_docdir/%name
install -m 755 -d %buildroot%_libdir/%name/plugins
install -m 755 -d %buildroot%_datadir/mime/packages

#cp unix/resources/doc/* %buildroot%_datadir/%name/doc/
cp unix/resources/fonts/*.lff %buildroot%_datadir/%name/fonts/
cp -r unix/resources/library/* %buildroot%_datadir/%name/library/
cp unix/resources/patterns/*.dxf %buildroot%_datadir/%name/patterns/
cp unix/resources/qm/*.qm %buildroot%_datadir/%name/qm/
cp unix/resources/plugins/* %buildroot%_libdir/%name/plugins/
find %buildroot%_datadir/%name -type f -exec chmod 644 {} \;

install -Dm 755 unix/%name %buildroot%_bindir/%name
install -Dm 644 desktop/%name.desktop %buildroot%_desktopdir/%name.desktop
install -Dm 644 desktop/%name.sharedmimeinfo %buildroot%_datadir/mime/packages/%name.xml
install -Dm 644 desktop/graphics_icons_and_splash/Icon\ LibreCAD/Icon_Librecad.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg

%files
%doc LICENSE README.md
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/mime/packages/%name.xml

%files data
%dir %_datadir/%name/
%_datadir/%name/fonts/
%_datadir/%name/library/
%_datadir/%name/patterns/
%_datadir/%name/qm/

#files doc
#_datadir/%name/doc/*

%files plugins
%_libdir/%name/plugins/

%changelog
