%def_enable snapshot

%define ver_major 0.19
%define api_ver 1

%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_disable check

Name: libsecret
Version: %ver_major.1
Release: alt2.1

Summary: A client library for the Secret Service DBus API
Group: System/Libraries
License: LGPLv2
Url: https://wiki.gnome.org/Projects/Libsecret

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
#VCS: git://git.gnome.org/libsecret
Source: %name-%version.tar
%endif
# "Create default collection after DBus.Error.UnknownObject" (ALT #40714)
Patch10: libsecret-0.20.4-up-d620c79d83acc1bae0bbd7153a691f952b74ca31.patch

%define glib_ver 2.44.0
%define vala_ver 0.17.2.12
%define gcrypt_ver 1.4.5

BuildRequires(pre): meson >= 0.50
BuildRequires(pre): rpm-macros-valgrind
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver
BuildRequires: gtk-doc xsltproc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver}
%{?_enable_check:
BuildRequires: /proc dbus-tools-gui python3-module-dbus
BuildRequires: python3-module-pygobject python3-module-mock libgjs}

%ifarch %valgrind_arches
BuildRequires: valgrind-devel
%endif

%description
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

%package devel
Summary: Development files and libraries for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides files for development with %name.

%package devel-doc
Summary: Development documentaion for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides development documentations for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for %name.

%prep
%setup
find . -name "*.py" -print0 | xargs -r0 sed -i 's|\(#\!/usr/bin/env python\)|\13|' --
%patch10 -p1

%meson \
%{?_disable_gtk_doc:-Dgtk_doc=false} \
%{?_disable_vala:-Dvapi=false}
%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
dbus-run-session %meson_test

%files -f %name.lang
%_bindir/secret-tool
%_libdir/%name-%api_ver.so.*
%_man1dir/secret-tool.1.*
%doc AUTHORS README* NEWS

%files devel
%_includedir/%name-%api_ver
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-unstable.pc
%if_enabled vala
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-%api_ver.deps
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/Secret-%api_ver.typelib

%files gir-devel
%_girdir/Secret-%api_ver.gir
%endif


%changelog
