%def_enable snapshot
%define oname soundtouch
%def_enable check

Name: libsoundtouch
Version: 2.1.2
Release: alt1

Summary: SoundTouch audio processing library
Group: System/Libraries
License: LGPLv2.1
Url: http://www.surina.net/soundtouch/

%if_disabled snapshot
Source: http://www.surina.net/%oname/%{oname}-%version.tar.gz
%else
# VCS: https://gitlab.com/soundtouch/soundtouch
Source: %{oname}-%version.tar
%endif

BuildRequires: gcc-c++ libstdc++-devel

%description
SoundTouch is an open-source audio processing library that allows changing
the sound tempo, pitch and playback rate parameters independently from
each other, i.e.:
 - Sound tempo can be increased or decreased while maintaining the original pitch
 - Sound pitch can be increased or decreased while maintaining the original tempo
 - Change playback rate that affects both tempo and pi

%package devel
Summary: Libraries/include files for development with %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Libraries/include files for development with %name.

%prep
%setup -n %oname-%version

%build
#touch NEWS README AUTHORS ChangeLog
#%autoreconf
./bootstrap
%configure --disable-static
%make_build

%install
%makeinstall_std
rm -rf %buildroot/%_prefix/doc

%check
%make check

%files
%_bindir/soundstretch
%_libdir/libSoundTouch.so.*
%doc README.html

%files devel
%_includedir/%oname/
%_libdir/libSoundTouch.so
%_aclocaldir/%oname.m4
%_pkgconfigdir/%oname.pc

%changelog
