%define _name xfconf

%def_without perl
%def_enable introspection
%def_enable vala
%def_disable gsettings

Name: lib%_name
Version: 4.14.4
Release: alt1

Summary: Hierarchical configuration system for Xfce
Summary (ru_RU.UTF-8): Система конфигурации Xfce
License: GPL-2.0-only and LGPL-2.0-only
Group: Graphical desktop/XFce
Vcs: https://gitlab.xfce.org/xfce/xfconf.git
Url: https://www.xfce.org/
Packager: Xfce Team <xfce@packages.altlinux.org>

Source: %_name-%version.tar
Patch: %_name-%version-%release.patch

%define _unpackaged_files_terminate_build 1

Requires: xfce4-common
Requires: dbus-tools-gui
BuildPreReq: rpm-build-xfce4 libxfce4util-devel xfce4-dev-tools
BuildRequires: libgio-devel libdbus-devel
%if_with perl
BuildPreReq: rpm-build-perl perl-devel perl-ExtUtils-Depends perl-ExtUtils-PkgConfig perl-Glib-devel
%endif
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}
BuildRequires: gtk-doc intltool

%description
Xfconf is a hierarchical (tree-like) configuration system where the
immediate child nodes of the root are called "channels".  All settings
beneath the channel nodes are called "properties".

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for the %name library.

%package -n %_name-utils
Summary: Utils for Xfce configuration system
License: GPL-2.0-only
Group: Graphical desktop/XFce
Requires: %name = %version-%release

%description -n %_name-utils
Xfconfd is a small daemon that handles storage and retrieval of settings, as well
as notifying interested applications about changes to settings. It doesn't require
a GUI, so it could even be used for command-line applications.

Xfconf-query might be one of the tools many users have been waiting on for years,
especially those hanging around in our IRC channel. Instead of having to guide new
users through several dialogs and windows, it is now possible to have every control
over your Xfce desktop at your fingertips. You can view or change any setting stored
in xfconf with xfconf-query.

%if_with perl
%package -n perl-%_name
Summary:        Perl modules for xfconf
Group:          Development/Perl
Requires:       %name = %version-%release

%description -n perl-%_name
This package includes the perl modules and files you will need to
interact with xfconf using perl.
%endif

%if_enabled introspection
%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.
%endif

%if_enabled vala
%package vala
Summary: Vala bindings for %name
License: LGPLv2.1+
Group: System/Libraries
Requires: %name-devel = %EVR
BuildArch: noarch

%description vala
Vala bindings for %name.
%endif

%prep
%setup -n %_name-%version
%patch -p1

%build
# Don't use git tag in version.
%xfce4_drop_gitvtag xfconf_version_tag configure.ac.in
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
%if_with perl
	--with-perl-options=INSTALLDIRS="vendor" \
	--enable-perl-bindings \
%else
	--disable-perl-bindings \
%endif
	%{subst_enable introspection} \
	%{subst_enable vala} \
%if_enabled gsetings
	--enable-gsettings-backend \
%else
	--disable-gsettings-backend \
%endif
	--enable-gtk-doc \
	--enable-debug=minimum
%make_build

%install
mkdir -p %buildroot/%_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml

%makeinstall_std
%find_lang %_name

%files -f %_name.lang
%doc AUTHORS NEWS
%_sysconfdir/xdg/xfce4/xfconf
%_libdir/*.so.*
%if_enabled gsetings
%_libdir/gio/modules/*.so

%exclude %_libdir/gio/modules/*.la
%endif

%files devel
%doc %_datadir/gtk-doc/html/%_name
%_includedir/xfce4/xfconf-0
%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n %_name-utils
%_bindir/*
%_libdir/xfce4/xfconf/
%_datadir/dbus-1/services/*.service

%if_with perl
%files -n perl-%_name
%perl_vendor_autolib/Xfce4*
%perl_vendor_archlib/Xfce4*
%endif

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/Xfconf-0.typelib

%files gir-devel
%_datadir/gir-1.0/Xfconf-0.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/libxfconf*
%endif

%changelog
