
Name: liferea
Version: 1.12.7
Release: alt1
Summary: A RSS News Reader for GNOME
License: GPLv2
Group: Networking/News
Url: https://lzone.de/liferea

Obsoletes: %name-gtkhtml < %version-%release %name-xulrunner < %version-%release
Provides: %name-backend = %version-%release %name-gtkhtml = %version-%release %name-xulrunner = %version-%release
# https://github.com/lwindolf/liferea.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: libpeas-python3-loader
Requires: dconf gnome-icon-theme

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_compile_include %_libdir/%name/plugins

BuildRequires(pre): gobject-introspection-devel
BuildRequires(pre): rpm-build-python3 python3-devel
BuildRequires: python3-module-pygobject3-devel
BuildRequires: gcc-c++ intltool
BuildRequires: pkgconfig(gtk+-3.0) >= 3.22.0
BuildRequires: pkgconfig(glib-2.0) >= 2.50.0 pkgconfig(gio-2.0) >= 2.50.0 pkgconfig(gmodule-2.0) >= 2.0.0 pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(pango) >= 1.4.0
BuildRequires: pkgconfig(libxml-2.0) >= 2.6.27 pkgconfig(libxslt) >= 1.1.19
BuildRequires: pkgconfig(sqlite3) >= 3.7.0
BuildRequires: pkgconfig(libsoup-2.4) >= 2.42 pkgconfig(webkit2gtk-4.0) pkgconfig(json-glib-1.0) pkgconfig(webkit2gtk-web-extension-4.0)
BuildRequires: pkgconfig(gobject-introspection-1.0) gir(Gtk) = 3.0
BuildRequires: pkgconfig(gsettings-desktop-schemas)
BuildRequires: pkgconfig(libpeas-1.0) >= 1.0.0 pkgconfig(libpeas-gtk-1.0) >= 1.0.0

%set_typelibdir %_libdir/%name/girepository-1.0

%description
Liferea is a desktop feed reader/news aggregator that brings together
all of the content from your favorite subscriptions into a simple interface
that makes it easy to organize and browse feeds.
Its GUI is similar to a desktop mail/newsclient, with an embedded graphical browser.

%package plugins-gnome-keyring
Summary: GNOME Keyring Support for the %name
Group: Networking/News
Requires: %name = %version-%release

%description plugins-gnome-keyring
Allow Liferea to use GNOME keyring as password store

%package plugins-media-player
Summary: Play music and videos directly from Liferea
Group: Networking/News
Requires: %name = %version-%release

%description plugins-media-player
Play music and videos directly from Liferea

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--enable-introspection \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS COPYING ChangeLog
%dir %_libdir/%name/plugins
%_bindir/*
%_libdir/%name/girepository-1.0/*.typelib
%_datadir/%name
%_datadir/glib-2.0/schemas/*.xml
%_datadir/GConf/gsettings/%name.convert
%_datadir/appdata/%name.appdata.xml
%_datadir/applications/net.sourceforge.liferea.desktop
%_datadir/dbus-1/services/net.sourceforge.liferea.service
%_datadir/icons/hicolor/*/apps/*
%_man1dir/%name.*
%_libdir/%name/web-extension/*.so


%dir %_libdir/%name/plugins
%dir %_libdir/%name/plugins/__pycache__

# plugins. may be separated packages?
%_libdir/%name/plugins/bold-unread.*
%_libdir/%name/plugins/__pycache__/bold-unread.*
%_libdir/%name/plugins/headerbar.*
%_libdir/%name/plugins/__pycache__/headerbar.*
%_libdir/%name/plugins/libnotify.*
%_libdir/%name/plugins/__pycache__/libnotify.*
%_libdir/%name/plugins/plugin-installer.*
%_libdir/%name/plugins/__pycache__/plugin-installer.*
%_libdir/%name/plugins/trayicon.*
%_libdir/%name/plugins/__pycache__/trayicon.*

%files plugins-gnome-keyring
%_libdir/%name/plugins/gnome-keyring.*
%_libdir/%name/plugins/__pycache__/gnome-keyring.*

%files plugins-media-player
%_libdir/%name/plugins/media-player.*
%_libdir/%name/plugins/__pycache__/media-player.*

%changelog
