%define _libexecdir %_prefix/libexec
%define _localstatedir %_var
%def_enable introspection
%def_enable systemd
%def_enable qt
%def_enable qt5

Name: lightdm
Version: 1.30.0
Release: alt14
Summary: Lightweight Display Manager
Group: Graphical desktop/Other
License: GPLv3+
Url: https://launchpad.net/lightdm

Source: %name-%version.tar

Patch1:  %name-1.30.0-cancelling.patch
Patch2:  %name-1.30.0-chauthtok.patch
Patch3:  %name-1.30.0-default-session.patch
Patch4:  %name-1.30.0-default-username.patch
Patch5:  %name-1.30.0-login-unknown.patch
Patch6:  %name-1.30.0-switch.patch
Patch7:  %name-1.30.0-alt-env.patch
Patch8:  %name-1.30.0-alt-config.patch
Patch9:  %name-1.30.0-alt-01-Xgreeter.patch
Patch10: %name-1.30.0-alt-02-hide-users.patch
Patch11: %name-1.30.0-alt-03-login-unknown.patch
Patch12: %name-1.30.0-alt-pam.patch
Patch13: %name-1.30.0-alt-polkit.patch
Patch14: %name-1.30.0-alt-shells.patch
Patch15: %name-1.30.0-alt-04-systemd.patch
Patch16: %name-1.30.0-alt-05-tmpfiles.patch
Patch17: %name-1.30.0-alt-i18n.patch
Patch18: lightdm-1.30.0-reread-dmrc-alt.patch
Patch19: %name-1.30.0-alt-wayland-session.patch
Patch20: %name-1.30.0-alt-lock-tty.patch
Patch21: %name-1.30.0-alt-select-vt.patch

Requires: dm-tool

BuildRequires: gcc-c++ intltool
BuildRequires: pkgconfig(glib-2.0) >= 2.30 pkgconfig(gio-2.0) >= 2.26  pkgconfig(gio-unix-2.0)  pkgconfig(xdmcp)  pkgconfig(xcb)
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(xcb)
BuildRequires: libdbus-glib-devel
BuildRequires: gtk-doc yelp-tools itstool
BuildRequires: libpam-devel
BuildRequires: libgcrypt-devel
BuildRequires: libvala-devel vala-tools
BuildRequires: libaudit-devel
BuildRequires: pkgconfig(glib-2.0) pkgconfig(gio-2.0) >= 2.26 pkgconfig(gio-unix-2.0) pkgconfig(gobject-2.0) pkgconfig(libxklavier) pkgconfig(x11)
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_qt:BuildRequires: pkgconfig(QtCore) pkgconfig(QtDBus) pkgconfig(QtGui) /usr/bin/moc-qt4}
%{?_enable_qt5:BuildRequires: pkgconfig(Qt5Core) pkgconfig(Qt5DBus) pkgconfig(Qt5Gui) /usr/bin/moc-qt5}

%description
LightDM is a lightweight, cross-desktop display manager. Its main features are
a well-defined greeter API allowing multiple GUIs, support for all display
manager use cases, with plugins where appropriate, low code complexity, and
fast performance. Due to its cross-platform nature greeters can be written in
several toolkits, including HTML/CSS/Javascript.

%package -n liblightdm-gobject
Group: System/Libraries
Summary: LightDM GObject Greeter Library
License: LGPLv2+

%description -n liblightdm-gobject
A library for LightDM greeters based on GObject which interfaces with LightDM
and provides common greeter functionality.

%package -n liblightdm-qt
Group: System/Libraries
Summary: LightDM Qt Greeter Library
License: LGPLv2+

%description -n liblightdm-qt
A library for LightDM greeters based on Qt which interfaces with LightDM and
provides common greeter functionality.

%package -n liblightdm-qt5
Group: System/Libraries
Summary: LightDM Qt5 Greeter Library
License: LGPLv2+

%description -n liblightdm-qt5
A library for LightDM greeters based on Qt5 which interfaces with LightDM and
provides common greeter functionality.

%package devel
Group: Development/C
Summary: Development Files for LightDM
Requires: %name

%description devel
This package provides all necessary files for developing plugins, greeters, and
additional interface libraries for LightDM.

%package devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
Contains developer documentation for %name.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name

%description gir
GObject introspection data for the %name

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir

%description gir-devel
GObject introspection devel data for the %name

%package -n dm-tool
Summary: Display Manager control utility
Group: Graphical desktop/Other
License: GPLv3+

%description -n dm-tool
dm-tool utility controls a FreeDesktop.org-compatible display
manager via D-Bus.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p2
%patch19 -p1
%patch20 -p1
%patch21 -p1

%ifarch %e2k
# until apx. lcc-1.23.01
sed -i 's,-Werror=pointer-arith,,' configure.ac
%endif

%build
%ifarch %e2k
export CXXFLAGS="%optflags -std=gnu++11"
%endif
%autoreconf
%configure \
	%{subst_enable introspection} \
	--disable-static \
	--disable-tests \
	--enable-gtk-doc \
	%{?_enable_qt:--enable-liblightdm-qt} \
	%{?_enable_qt5:--enable-liblightdm-qt5} \
	--libexecdir=%_libexecdir \
	--with-greeter-user=_ldm \
	--with-greeter-session=%name-default-greeter

%make_build

%install
%make DESTDIR=%buildroot install

# We don't ship AppAmor
rm -rf %buildroot%_sysconfdir/apparmor.d/
# omit upstart support
rm -rf %buildroot%_sysconfdir/init

mkdir -p %buildroot%_sysconfdir/%name/lightdm.conf.d
mkdir -p %buildroot%_datadir/%name/lightdm.conf.d
mkdir -p %buildroot%_datadir/%name/sessions
mkdir -p %buildroot%_datadir/%name/remote-sessions
mkdir -p %buildroot%_localstatedir/log/%name
mkdir -p %buildroot%_localstatedir/cache/%name
mkdir -p %buildroot%_localstatedir/lib/lightdm-data

%if_disabled systemd
sed -i '/pam_systemd.so/d' %buildroot%_sysconfdir/pam.d/%name-greeter
%endif

%find_lang --with-gnome %name

%pre
%_sbindir/groupadd -r -f _ldm >/dev/null 2>&1 || :
%_sbindir/useradd -M -r -d %_localstatedir/lib/ldm -s /bin/false -c "LightDM daemon" -g _ldm _ldm >/dev/null 2>&1 || :

%post
if [ $1 -eq 1 ] ; then
        SYSTEMCTL=/sbin/systemctl
        # Initial installation
        $SYSTEMCTL preset %name.service > /dev/null 2>&1 ||:
fi

%preun
if [ $1 -eq 0 ] ; then
        SYSTEMCTL=/sbin/systemctl
        # Package removal, not upgrade
        $SYSTEMCTL --no-reload disable %name.service > /dev/null 2>&1 ||:
        $SYSTEMCTL stop %name.service > /dev/null 2>&1 ||:
fi


%files -f %name.lang
%doc NEWS
%config %_sysconfdir/dbus-1/system.d/org.freedesktop.DisplayManager.conf
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/lightdm.conf.d
%config(noreplace) %_sysconfdir/%name/*.conf
%config(noreplace) %_sysconfdir/pam.d/*
%_sbindir/%name
%_unitdir/%name.service
%exclude %_man1dir/dm-tool.*
%dir %_datadir/%name/sessions
%dir %_datadir/%name/remote-sessions
%dir %_datadir/%name/lightdm.conf.d
%_man1dir/*
%_libexecdir/*
%attr(775,root,_ldm) %dir %_localstatedir/log/%name
%attr(775,_ldm,_ldm) %dir %_localstatedir/cache/%name
%attr(750,_ldm,_ldm) %dir %_localstatedir/lib/ldm
%attr(640,_ldm,_ldm) %_localstatedir/lib/ldm/.pam_environment
%attr(750,_ldm,_ldm) %dir %_localstatedir/lib/lightdm-data
/lib/tmpfiles.d/%name.conf
%_datadir/polkit-1/rules.d/%name.rules
%_datadir/polkit-1/actions/org.freedesktop.DisplayManager.AccountsService.policy
%_datadir/accountsservice/interfaces/org.freedesktop.DisplayManager.AccountsService.xml
%_datadir/dbus-1/interfaces/org.freedesktop.DisplayManager.AccountsService.xml
%exclude %_datadir/bash-completion/completions/dm-tool
%_datadir/bash-completion/completions/*
%_controldir/*
%_sysconfdir/X11/*.lightdm

%files -n liblightdm-gobject
%_libdir/liblightdm-gobject-?.so.*

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif

%if_enabled qt
%files -n liblightdm-qt
%_libdir/liblightdm-qt-?.so.*
%endif

%if_enabled qt5
%files -n liblightdm-qt5
%_libdir/liblightdm-qt5-?.so.*
%endif

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_datadir/vala/vapi/*

%files devel-doc
%_datadir/gtk-doc/html/*

%files -n dm-tool
%_bindir/dm-tool
%_datadir/bash-completion/completions/dm-tool
%_man1dir/dm-tool.*

%changelog
