%define _unpackaged_files_terminate_build 1

Name: local-policy
Version: 0.5.0
Release: alt1

Summary: ALT Local policies
License: GPLv2+
Group: Other
Url: http://git.altlinux.org/people/sin/packages/local-policy.git

BuildArch: noarch

Requires: control
Requires: control-sshd-permit-root-login

Source0: %name-%version.tar

%description
Local policies for ALT solutions based on Sisyphus
includes additional control facilities and default policies
templates in PReg format converted to XML.

%prep
%setup -q

%install
for i in sshd-gssapi-auth \
         sshd-allow-groups-list \
         ssh-gssapi-auth \
         krb5-conf-ccache \
         ldap-reverse-dns-lookup \
         ldap-tls-cert-check \
         sssd-ad-gpo-access-control \
         sssd-ad-gpo-ignore-unreadable \
         sssd-cache-credentials \
         sssd-drop-privileges \
         sssd-dyndns-update \
         sssd-dyndns-update-ptr \
         sssd-dyndns-refresh-interval \
         sssd-dyndns-ttl \
         autofs-browse-mode \
         smb-conf-idmap-backend \
         smb-conf-idmap-range
do
        install -pD -m755 "controls/$i" \
                "%buildroot%_sysconfdir/control.d/facilities/$i"
done

install -pD -m755 "controls/functions-local-policy" \
        "%buildroot%_sysconfdir/control.d/"

mkdir -p "%buildroot%_datadir/%name"
cp -r policies/* "%buildroot%_datadir/%name"
mkdir -p "%buildroot%_sysconfdir/%name"

%pre
%_sbindir/groupadd -r -f remote 2> /dev/null ||:

%files
%dir %_sysconfdir/%name
%_sysconfdir/control.d/facilities/*
%_sysconfdir/control.d/functions-local-policy
%dir %_datadir/%name
%_datadir/%name/*

%changelog
