Name: lshw
Version: B.02.19.2
Release: alt2

Summary: Hardware Lister
License: GPL-2.0
Group: System/Kernel and hardware
Url: http://ezix.org/project/wiki/HardwareLiSter

Source: %name-%version.tar
Source100: lshw-icons.tar.bz2
Source102: lshw-gtk.1

Patch1: lshw-fix-desktop.patch
Patch2: lshw-2.13-gcc43.patch
# fc (rhbz #1332486)
Patch10: lshw-non-root.patch
Patch11: lshw-B.02.19.2-cmake.patch
Patch12: lshw-B.02.18-scandir.patch
Patch13: lshw-fix-mmc.patch
Patch14: lshw-fix-segfault-in-apfs-volume-code.patch

Requires: pciids usbids

BuildRequires(pre): cmake rpm-build-ninja
BuildRequires: gcc-c++ libgtk+2-devel libsqlite3-devel

%description
lshw (Hardware Lister) is a small tool to provide detailed informaton on the
hardware configuration of the machine. It can report exact memory configuration,
firmware version, mainboard configuration, CPU version and speed, cache
configuration, bus speed, etc. on DMI-capable x86 systems, on some PowerPC
machines (PowerMac G4 is known to work) and AMD64.

Information can be output in plain text, XML or HTML.

%package gui
Summary: Graphical hardware lister
Group: System/Kernel and hardware
Requires: pciids usbids
Requires: lshw = %version-%release

%description gui
lshw (Hardware Lister) is a small tool to provide detailed informaton on the
hardware configuration of the machine. It can report exact memory configuration,
firmware version, mainboard configuration, CPU version and speed, cache
configuration, bus speed, etc. on DMI-capable x86 systems, on some PowerPC
machines (PowerMac G4 is known to work) and AMD64.

This package provides graphical (GTK+) front-end to lshw.

%prep
%setup -a 100
%patch2 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%cmake -DNOLOGO=ON -DHWDATA=OFF -DPOLICYKIT=ON -DBUILD_SHARED_LIBS=OFF -GNinja
%ninja_build -C BUILD

%install
%ninja_install -C BUILD
patch -p0 -d %buildroot < %PATCH1

ln -s gtk-lshw %buildroot%_sbindir/lshw-gui

install -Dp -m644 lshw.png %buildroot%_pixmapsdir/lshw.png
install -Dp -m644 lshw-16x16.png %buildroot%_miconsdir/lshw.png
install -Dp -m644 lshw-32x32.png %buildroot%_niconsdir/lshw.png
install -Dp -m644 lshw-48x48.png %buildroot%_liconsdir/lshw.png

# Install man page
install -Dpm0644 %SOURCE102 %buildroot%_man1dir/lshw-gtk.1

%find_lang lshw

%files -f lshw.lang
%doc README.md
%_sbindir/lshw
%_man1dir/lshw.1*

%files gui
%_bindir/lshw-gui
%_sbindir/gtk-lshw
%_sbindir/lshw-gui
%dir %_datadir/lshw
%_datadir/lshw/ui/
%_datadir/lshw/artwork/
%_pixmapsdir/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_desktopdir/*
%_man1dir/lshw-gtk.1*
%_datadir/appdata/*.appdata.xml
%_datadir/polkit-1/actions/*.policy

%changelog
