#%luarocks_dbdir is defined in rpm-macros-lua package

#TODO:
#   1. check rpath is clear

Name: luarocks
Version: 2.4.2
Release: alt4
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
Url: http://www.luarocks.org
Packager: Ildar Mulyukov <ildar@altlinux.ru>
#%%luarocks_dbdir
Provides: %_prefix/lib/luarocks/rocks

Source: http://luarocks.org/releases/%name-%version.tar
#.gz
Source1: %name.filetrigger
Source2: %name-files.req.list

Requires: chrpath wget p7zip unzip zip
# We want any of /usr/bin/lua-5.x
%add_findreq_skiplist %_bindir/*
Requires: lua5

BuildPreReq: rpm-macros-lua >= 1.3
# Automatically added by buildreq on Wed Sep 20 2017
# optimized out: lua5.3 python-base
BuildRequires: lua-devel lua5.1 unzip wget

%description
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

%prep
%setup
sed -i 's/^if .*header_version.*LUA_VERSION.*$/if [ OK ]/' configure

%build
for v in 5.1 5.3; do
	cp -a . ../build-$v
	pushd ../build-$v
	./configure --prefix=%prefix --lua-version=$v
	make
	popd
done

%install
mkdir -p %buildroot{%lua_modulesdir/%name/,%luarocks_dbdir/,%_rpmlibdir/}
for v in 5.1 5.3; do
	%makeinstall_std -C ../build-$v
	sed -i "s|/usr/bin/env lua$|/usr/bin/env lua$v|" %buildroot%_bindir/%{name}*-$v
#move arch-dependent parts
# pending https://github.com/keplerproject/luarocks/issues/86
mkdir -p %buildroot%_libdir/lua/$v/%name
mv %buildroot%_datadir/lua/$v/%name/\
site_config.lua \
	%buildroot%_libdir/lua/$v/%name
#enable lib -> lib64 right path settings
cat >> %buildroot%_sysconfdir/%name/config-$v.lua <<EOF
gcc_rpath = false
lib_modules_path = "/%_lib/lua/"..lua_version
EOF

SITECFG_ADDITION="site_config.LUAROCKS_EXTERNAL_DEPS_SUBDIRS =\\
    {\\
      bin = \"bin\",\\
      lib = \"%_lib\",\\
      include = \"include\"\\
    }"
sed -i "/^return/ i $SITECFG_ADDITION" \
	%buildroot%_libdir/lua/$v/%name/site_config.lua
done

#%%ghost
touch %buildroot%luarocks_dbdir/{index.html,manifest{,-5.{1,2,3}}}
# RPM triggers
install -m755 %SOURCE1 %buildroot%_rpmlibdir/
install -m644 %SOURCE2 %buildroot%_rpmlibdir/

%files
%_sysconfdir/%name
%_bindir/%{name}*
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir
%ghost %luarocks_dbdir/index.html
%ghost %luarocks_dbdir/manifest*
%_rpmlibdir/%{name}*
%lua_modulesdir/%name
%lua_modulesdir_noarch/%name
%lua51_modulesdir/%name
%lua51_modulesdir_noarch/%name
%doc COPYING README*

%changelog
