#
# lxc: linux Container library
#
# (C) Copyright IBM Corp. 2007, 2008
# (C) ALT Linux Team 2009-2020
#
# Authors:
# Daniel Lezcano <dlezcano at fr.ibm.com>
# Denis Pynkin <dans at altlinux.org>
# Vladimir D. Seleznev <vseleznv at altlinux.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Spec file adapted for ALT Linux.

%def_with systemd

Name: lxc
Version: 4.0.2
Release: alt1

Url: https://linuxcontainers.org/

# https://github.com/lxc/lxc.git
Source0: %name-%version.tar
Source1: lxc-net.sysconfig
Source2: lxc-user-nic.control

Patch2: 0002-FEDORA-lxc-net.service-wants-network-online.target.patch
Patch3: 0003-ALT-Fixed-_have-macro-in-bash-completion.patch
Patch4: 0004-ALT-tune-SysVinit-scripts.patch
Patch5: 0005-ALT-make-lxc-and-lxc-net-init-scripts-disabled-by-de.patch
Patch6: 0006-ALT-sysvinit-don-t-start-services-at-boot-by-default.patch

Summary: Linux Containers
Group: System/Configuration/Other
License: LGPL-2.1-or-later
Requires: libcap gzip-utils
%ifarch x86_64 %arm
Requires: criu
%endif
Requires: iproute2 dnsmasq wget
Obsoletes: lxc-sysvinit
BuildRequires: libcap-devel docbook-utils glibc-kernheaders
BuildRequires: docbook2X xsltproc
BuildRequires: rpm-macros-alternatives
BuildRequires: libnih-devel
BuildRequires: libdbus-devel
BuildRequires: libgnutls-devel
BuildRequires: libseccomp-devel
BuildRequires: libselinux-devel

# Skip automatic dependency to optional lsb scripts
%add_findreq_skiplist %_initdir/*

# Needed to disable auto requirements from distro templates
%add_findreq_skiplist %_datadir/lxc/*

# Do not need to check
%add_findreq_skiplist %_libexecdir/lxc/lxc-apparmor-load
%add_findreq_skiplist %_libexecdir/lxc/lxc-net

Requires: openssl rsync
BuildRequires: libcap libcap-devel docbook2X graphviz

%{?_with_systemd:BuildRequires: systemd-devel}

%description
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the lxc-* tools, which can be used to start a single
daemon in a container, or to boot an entire "containerized" system, and to
manage and debug your containers.

%package libs
Summary: Shared library files for %name
Group: System/Configuration/Other
Requires(pre): /usr/sbin/groupadd
Requires(pre): control

%description libs
The %name-libs package contains libraries for running %name applications.

%package devel
Summary: development library for %name
Group: Development/Other

%description devel
The %name-devel package contains header files and library needed for
development of the linux containers.

%set_pam_name pam_cgfs
%package -n %pam_name
Summary: %summary
Group: System/Base
BuildRequires(pre): libpam-devel

%description -n %pam_name
%summary
This package provides a Pluggable Authentication Module (PAM) to provide
logged-in users with a set of cgroups which they can administer.
This allows for instance unprivileged containers, and session
management using cgroup process tracking.

%prep
%setup
%autopatch -p1

%build
%autoreconf
%configure \
	--disable-werror \
	--disable-cgmanager \
	--disable-rpath \
	--disable-static \
	--enable-capabilities \
	--enable-pam \
	--enable-seccomp \
	--enable-selinux \
	--localstatedir=%_var \
	--with-config-path=%_var/lib/lxc \
	--with-distro=altlinux \
	--with-init-script=%{?_with_systemd:systemd,}sysvinit

%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_localstatedir/lxc
mkdir -p %buildroot%_cachedir/lxc
install -pm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/lxc-net
install -pDm755 %SOURCE2 %buildroot%_controldir/lxc-user-nic

%post
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add lxc
	/sbin/chkconfig --add lxc-net
fi

%preun
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del lxc
	/sbin/chkconfig --del lxc-net
fi

%pre libs
groupadd -r -f vmusers ||:
%pre_control lxc-user-nic

%post libs
%post_control -s vmusers lxc-user-nic

%files
%doc COPYING doc/FAQ.txt
%_bindir/*

%_man1dir/lxc*
%_man5dir/lxc*
%_man7dir/lxc*

%_mandir/ja/*
%_mandir/ko/*

%_defaultdocdir/lxc
%_datadir/lxc

%_sysconfdir/bash_completion.d/lxc

%config(noreplace) %_sysconfdir/lxc/*
%config(noreplace) %_sysconfdir/sysconfig/lxc*

%_initdir/lxc
%_initdir/lxc-net
%if_with systemd
%_unitdir/lxc.service
%_unitdir/lxc@.service
%_unitdir/lxc-net.service
%endif

%files libs
%doc COPYING
%_controldir/lxc-user-nic
%attr(4710,root,vmusers) %_libexecdir/lxc/lxc-user-nic
%attr(555,root,root) %_libexecdir/lxc/lxc-containers
%attr(555,root,root) %_libexecdir/lxc/lxc-net
%_libexecdir/lxc/lxc-apparmor-load
%_libexecdir/lxc/lxc-containers
%_libexecdir/lxc/lxc-monitord
%_libexecdir/lxc/lxc-net
%_libexecdir/lxc/hooks

%_sbindir/init.lxc
# ALT#37718
#_sbindir/init.lxc.static
%_libdir/*.so.1*
%_localstatedir/lxc

%dir %_libdir/lxc/rootfs
%_libdir/lxc/rootfs/README

%files devel
%_includedir/lxc
%_libdir/*.so
%_pkgconfigdir/lxc.pc

%files -n %pam_name
%_pam_modules_dir/*
%_man8dir/pam_cgfs.8*

%changelog
