Name:		lxcfs
Version:	4.0.3
Release:	alt1
Summary:	FUSE filesystem for LXC

Group:		Development/Other
License:	Apache-2.0
URL:		https://github.com/lxc/lxcfs

Packager:	Denis Pynkin <dans@altlinux.ru>

Source0:	%name-%version.tar
Source1:	lxcfs.sysvinit

BuildRequires: libfuse-devel
BuildRequires: help2man

%define _check_contents_method relaxed

%description
FUSE filesystem for LXC, offering the following features:
 - a cgroupfs compatible view for unprivileged containers
 - a set of cgroup-aware files:
   - cpuinfo
   - meminfo
   - stat
   - uptime

%prep
%setup

%build
./bootstrap.sh
%configure --disable-static --with-init-script=systemd --localstatedir=%_var
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_localstatedir/%name
install -Dm0755 %SOURCE1 %buildroot%_initdir/lxcfs

find %buildroot -name '*.la' -delete

%post
[ -d "%_localstatedir/%name" ] || mkdir -p %_localstatedir/%name
%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS COPYING README.md
%_bindir/%name
%_libdir/%name/lib%name.so
%_man1dir/%name.1*
%_initdir/%name
%_unitdir/%name.service
%_datadir/lxc/config/common.conf.d/*
%dir %_datadir/%name
%_datadir/%name/*
%ghost %dir %_localstatedir/%name

%changelog
