Name: make-initrd
Version: 2.16.0
Release: alt2

Summary: Creates an initramfs image
License: GPL-3.0
Group: System/Base

Packager: Alexey Gladkov <legion@altlinux.ru>

BuildRequires: autoconf
BuildRequires: udev
BuildRequires: help2man
BuildRequires: libkmod-devel
BuildRequires: zlib-devel
BuildRequires: bzlib-devel
BuildRequires: liblzma-devel
BuildRequires: libzstd-devel
BuildRequires: libelf-devel
BuildRequires: libshell
BuildRequires: make-initrd-busybox

Provides: make-initrd(crc32c) = 1

Provides: mkinitrd = 2:%version-%release

Provides: make-initrd2 = %version-%release
Obsoletes: make-initrd2

Provides: kinit-utils = %version-%release
Obsoletes: kinit-utils

Requires: bash libshell make sed module-init-tools coreutils findutils grep glibc-utils
Requires: chrooted-resolv service util-linux

# Feature qemu
Requires: pciutils

# setsid, timeout, start-stop-daemon
Requires: make-initrd-busybox >= 1.32.1-alt3

# depinfo
Requires: libkmod >= 8-alt1

# make bug-report
Requires: tar

# Move /dev from initrd to the real system.
# 167: udevadm info --run
Requires: udev >= 167-alt1

# installkernel
Requires: bootloader-utils >= 0.4.10-alt1

# blkid
Requires: util-linux >= 2.17.2-alt1

# This avoids getting a dependency on sh from "#!/bin/sh".
#AutoReq: yes, nopam, noperl, nopython, noshell, notcl
AutoReq: noshell, noshebang

Source0: %name-%version.tar

%description
make-initrd is a new, uevent-driven initramfs infrastructure based around udev.

%package devmapper
Summary: device-mapper module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: dmsetup >= 1.02.44-alt3
AutoReq: noshell, noshebang

%description devmapper
device-mapper module for %name

%package lvm
Summary: LVM module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: lvm2
AutoReq: noshell, noshebang

%description lvm
LVM module for %name

%package luks
Summary: LUKS module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: cryptsetup
AutoReq: noshell, noshebang

%description luks
LUKS module for %name

%package nfs
Summary: NFS module for %name
Group: System/Base
AutoReq: noshell, noshebang

%description nfs
NFS module for %name

%package multipath
Summary: multipath module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: %name-devmapper = %version-%release
Requires: multipath-tools
AutoReq: noshell, noshebang

%description multipath
Multipath module for %name

%package plymouth
Summary: plymouth module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: plymouth
Requires: plymouth-plugin-label
Requires: fonts-ttf-dejavu
AutoReq: noshell, noshebang

%description plymouth
plymouth module for %name

%package mdadm
Summary: mdadm module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: mdadm
AutoReq: noshell, noshebang

%description mdadm
Mdadm module for %name

%package ucode
Summary: CPU microcode module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: iucode_tool, firmware-intel-ucode, linux-firmware
Requires: cpio
AutoReq: noshell, noshebang

%description ucode
CPU microcode autoloading module for %name

%package iscsi
Summary: iSCSI module for %name
Group: System/Base
Requires: %name = %version-%release
Requires: open-iscsi
AutoReq: noshell, noshebang

%description iscsi
iSCSI module for %name

%prep
%setup -q

%build
./autogen.sh
%configure \
	--libexecdir=%_prefix/libexec \
	--with-bootdir=/boot \
	--with-runtimedir=/lib/initrd \
	--with-kbddir=/lib/kbd \
	#
make

%install
%make_install DESTDIR=%buildroot install

%triggerin -- %name < 0.8.1-alt1
c="%_sysconfdir/initrd.mk"
if [ -s "$c" ] && ! grep -qs '^AUTODETECT[[:space:]]*=[[:space:]]*all[[:space:]]*' "$c"; then
	printf -- 'make-initrd: Migrating to new autodetect scheme ...\n' >&2
	sed -i -e 's/^\(AUTODETECT[[:space:]]*=.*\)$/# \1\nAUTODETECT = all/' "$c"
fi

%files
%dir %_sysconfdir/initrd.mk.d
%config(noreplace) %_sysconfdir/initrd.mk.d/*.mk.example
%config(noreplace) %_sysconfdir/initrd.mk
%_bindir/*
%_sbindir/*
%_datadir/%name
%_man1dir/*
/lib/initrd
%exclude %_datadir/%name/features/devmapper
%exclude %_datadir/%name/features/lvm
%exclude %_datadir/%name/features/luks
%exclude %_datadir/%name/features/nfsroot
%exclude %_datadir/%name/features/multipath
%exclude %_datadir/%name/features/plymouth
%exclude %_datadir/%name/features/mdadm
%exclude %_datadir/%name/features/ucode
%exclude %_datadir/%name/guess/ucode
%exclude %_datadir/%name/features/iscsi
%doc Documentation/*.md

%files devmapper
%_datadir/%name/features/devmapper

%files lvm
%_datadir/%name/features/lvm

%files luks
%_datadir/%name/features/luks

%files nfs
%_datadir/%name/features/nfsroot

%files multipath
%_datadir/%name/features/multipath

%files plymouth
%_datadir/%name/features/plymouth

%files mdadm
%_datadir/%name/features/mdadm

%ifarch %ix86 x86_64
%files ucode
%_datadir/%name/features/ucode
%_datadir/%name/guess/ucode
%endif

%files iscsi
%_datadir/%name/features/iscsi

%changelog
