Version: 4.9
Release: alt1
Name: mercurial
%setup_python_module %name

Summary: Mercurial source code management system
Group: Development/Other
License: GPLv2+
Url: https://mercurial-scm.org

Source0: %name-%version.tar

Packager: Yury Yurevich <anarresti@altlinux.org>

BuildPreReq: rpm-build-python
BuildRequires: python-devel asciidoc xmlto python-module-docutils

Provides: hg = %version-%release

#%add_python_req_skip win32api pywintypes win32com win32con win32file win32process win32gui winerror msvcrt
%add_findreq_skiplist %python_sitelibdir/hgext/*
%add_findreq_skiplist %python_sitelibdir/mercurial/win*
%add_findreq_skiplist %python_sitelibdir/mercurial/scmwin*
%add_findreq_skiplist %python_sitelibdir/mercurial/httpclient/tests/*
%add_findreq_skiplist %python_sitelibdir/mercurial/py3kcompat.py

%description
Mercurial is a fast fast, lightweight
Source Control Management system designed for
efficient handling of very large distributed projects

%package -n bash-completion-%name
Summary: Bash completion for mercurial
Group: Development/Other
BuildArch: noarch

%description -n bash-completion-%name
Bash completion for mercurial

%package -n %name-hgext
Summary: Mercurial bundled extensions
Group: Development/Other
Requires: %name = %version-%release, tk, python-module-Pygments

%description -n %name-hgext
Bundled extensions for Mercurial SCM. See
http://mercurial.selenic.com/wiki/UsingExtensions for details.
This extensions are included in package:

- acl -- Manage commit access to parts of a repo using control list
- alias -- User-defined command aliases
- bisect -- Quickly find revision that introduces a bug or feature
- bookmarks -- Markers on commits that move on commit
- bugzilla -- Update Bugzilla entries from commit messages
- children -- Display children revisions
- churn -- Show change statistics per author
- convert -- Convert repositories from other SCMs into Mercurial
- color -- Color output for the diff, status and qseries commands
- extdiff -- Compare changes using external programs
- fetch -- Conveniently pull, merge and update in one step
- gpg -- Sign changesets and check signatures using GnuPG
- graphlog -- Show revision history alongside an ASCII revision graph
- hgcia -- Send notifications to http://cia.navi.cx
- highlight -- Highlight syntax in the file revision view of hgweb
- imerge --Perform interactive, interruptible merges
- interhg -- Change changelog and summary text in InterWiki way
- keyword -- Use CVS-like keyword expandsion in tracked files
- mq -- Mercurail Patch Queues - manage changes as series of patches
- notify -- Send email to subscribed emails to notify repository changes
- pager -- Allows you to use pager
- parentrevspec -- Use git-like foo^ to refer to the parent of revision foo
- patchbomb -- Send a collection of changesets as a series of patch emails
- progress -- Show progress bars for some actions
- purge -- Purge all files and dirs that are not being tracked
- rebase -- Move revisions from one point to another
- record -- Comit changes per-hunk, like darcs record or git interactive commit
- relink -- Recreates hardlinks between repository clones
- schemes -- Add shortcuts to urls as url schemes
- share -- Share repository history between multiply repos
- transplant -- Cherry-picking, rebasing and changeset rewriting
- zeroconf -- Announce and browse repositories via zeroconf/bonjour

%prep
%setup

%build
%python_build_debug

make -C doc clean
make -C doc all

# TODO: run tests on build

%install
%python_install
install -D doc/hg.1 %buildroot%_man1dir/hg.1
install -D doc/hgrc.5 %buildroot%_man5dir/hgrc.5
install -D doc/hgignore.5 %buildroot%_man5dir/hgignore.5
install -D contrib/bash_completion %buildroot%_sysconfdir/bash_completion.d/%name
install -D contrib/hgk  %buildroot%_bindir/hgk
install contrib/hg-ssh %buildroot%_bindir/

mkdir -p %buildroot%_sysconfdir/%name/hgrc.d

%files
%doc CONTRIBUTORS README.rst contrib doc/*html
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/hgrc.d
%_bindir/hg
%_bindir/hg-ssh
%python_sitelibdir/mercurial
%python_sitelibdir/hgdemandimport
%python_sitelibdir/%name-*py%_python_version.egg-info
%_man1dir/hg.*
%_man5dir/hgrc.*
%_man5dir/hgignore.*

%exclude %python_sitelibdir/hgext/*

%files -n bash-completion-%name
%_sysconfdir/bash_completion.d/%name

%files -n %name-hgext
%_bindir/hgk
%python_sitelibdir/hgext
%python_sitelibdir/hgext3rd

%changelog
