Name: mldonkey
Version: 3.1.6
Release: alt2
Group: Networking/File transfer
Summary: The eDonkey client for Linux/Unix/Windows
URL: https://github.com/ygrek/mldonkey
License: GPL
# git https://github.com/ygrek/mldonkey
Source: %name-%version.tar
Source1: %name.service
Source2: %name.logrotate
Source3: %name.tmpfiles.conf
Patch0: mldonkey-3.1.6-ocaml-4.06.0.patch

BuildRequires: bzlib-devel ocaml-camlp4-devel ocaml-lablgtk-devel  fontconfig libfreetype-devel glib2-devel libatk-devel libgd2-devel libjpeg-devel libncurses-devel libpango-devel libpng-devel libtiff-devel libwebp-devel librsvg-devel libXpm-devel ocaml-runtime pkgconfig wget zlib-devel ocaml-num-devel
BuildRequires: libgtk+2-devel desktop-file-utils
# for mldonkey-submit
BuildRequires(pre): perl-libwww-perl

Provides: mldonkey-server
Obsoletes: mldonkey-server

%description
MLDonkey - the Open Source eDonkey client
features:
* 100%% OpenSource, GPL license
* runs on Linux, Unix, Solaris, MacOSX, MorphOS and Windows
* Core and Guis are separated or linked.
* written in ObjectiveCaml, with some C and even some Assembler parts.
* OtherNetworksSupported, using separate executables
* built to run as daemon for days, weeks, ever... 

MLdonkey is a peer-to-peer file-sharing client completely written 
in Objective-Caml, that can be used to access the eDonkey2000, 
BitTorrent, Overnet, Direct Connect and Soulseek networks. It supports
downloads from multiple sources and corruption detection, complex search
requests, chat with friends, internationalization, history of search results,
etc...

%package client
Group: Networking/File transfer
Summary: Graphical frontend for mldonkey based on GTK
License: GPL

%description client
The GTK interface for mldonkey provides a convenient way of managing            
all mldonkey operations. It gives details about conected servers,               
downloaded files, friends and lets one search for files in a pleasing           
way.

%prep
%setup -q
%patch0 -p1

%build
cd config
autoconf
cd ../
./configure --enable-largefile \
	    --sysconfdir=%_sysconfdir/mldonkey \
            --sharedstatedir=%_localstatedir/mldonkey \
            --localstatedir=%_localstatedir/mldonkey \
            --prefix=%_prefix \
	     --enable-gui=newgui2 \
	     --disable-rpath \
	     --enable-checks \
#
%make_build
%make_build utils
%__make make_torrent

%install
DONT_GPRINTIFY=1
export DONT_GPRINTIFY
%makeinstall_std

install -dm755 %buildroot%_bindir
install -dm755 %buildroot%_cachedir/%name
install -dm755 %buildroot%_libdir/mldonkey
install -dm755 %buildroot%_localstatedir/mldonkey/incoming
install -pm755 distrib/mldonkey_command %buildroot%_bindir/mldonkey_command
install -pm755 distrib/kill_mldonkey %buildroot%_bindir/kill_mldonkey
for util in copysources mld_hash get_range svg_converter subconv; do
    install -pm755 $util %buildroot%_bindir/$util ;
done
install -pm755 make_torrent %buildroot%_bindir/mldonkey_make_torrent
install -pm755 mlguistarter %buildroot%_bindir/mlguistarter
install -pm755 distrib/mldonkey_previewer %buildroot%_bindir/mldonkey_previewer

%__install -pD -m644 packages/rpm/%name-icon-16.png %buildroot/%_niconsdir/%name.png
%__install -pD -m644 packages/rpm/%name-icon-32.png %buildroot/%_miconsdir/%name.png
%__install -pD -m644 packages/rpm/%name-icon-48.png %buildroot/%_liconsdir/%name.png
desktop-file-install --dir=%buildroot%_desktopdir distrib/%name.desktop
install -dm755 %buildroot%_logdir/%name
install -pDm644 %SOURCE2 %buildroot%_logrotatedir/%name
install -pDm644 %SOURCE1 %buildroot%_unitdir/%name.service
install -pDm644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf
echo -e \
"temp_directory = \"%_var/cache/mldonkey\"\n"\
"incoming_directory = \"%_localstatedir/%name/incoming\"\n"\
"mldonkey_gui = \"%_bindir/mlgui\"\n"\
"mldonkey_bin = \"%_bindir/mldonkey\"\n"\
"log_file = \"%_logdir/mldonkey/mldonkey.log\"\n"\
> %buildroot%_localstatedir/%name/downloads.ini

%pre
getent group _%name >/dev/null || groupadd -r _%name
getent passwd _%name >/dev/null || \
    useradd -r -g _%name -d %_localstatedir/%name -s /sbin/nologin \
    -c "MLDonkey server" _%name


%files
%config(noreplace) %_sysconfdir/logrotate.d/mldonkey
%_unitdir/mldonkey.service
%_tmpfilesdir/%name.conf
%attr(750,_mldonkey,_mldonkey) %dir %_logdir/mldonkey
%attr(750,_mldonkey,_mldonkey) %dir %_cachedir/mldonkey
%attr(750,_mldonkey,_mldonkey) %dir %_localstatedir/mldonkey
%attr(770,_mldonkey,_mldonkey) %dir %_localstatedir/mldonkey/incoming
%config(noreplace) %_localstatedir/mldonkey/downloads.ini
%_bindir/mlnet
%_bindir/copysources
%_bindir/get_range
%_bindir/kill_mldonkey
%_bindir/mlbt
%_bindir/mld_hash
%_bindir/mldc
%_bindir/mldonkey_command
%_bindir/mldonkey
%_bindir/mlgnut
%_bindir/mlslsk
%_bindir/subconv
%_bindir/svg_converter
%_bindir/mldonkey_make_torrent

%files client
%doc  distrib/Authors.txt distrib/Bugs.txt distrib/ChangeLog distrib/Developers.txt Copying.txt
%_bindir/mlgui
%_bindir/mlnet+gui
%_bindir/mlbt+gui
%_bindir/mldc+gui
%_bindir/mldonkey+gui
%_bindir/mldonkey_gui
%_bindir/mlgnut+gui
%_bindir/mlslsk+gui
%_bindir/mlguistarter
%_bindir/mldonkey_previewer
%_desktopdir/%name.desktop
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png

%changelog
