%def_with nas
%def_with pulse
%def_with sdl

# list of audio output modules
%define mods alsa oss %{?_with_nas:nas} %{?_with_pulse:pulse} %{?_with_sdl:sdl}

Name: mpg123
Version: 1.25.12
Release: alt1

Summary: MPEG audio player
Group: Sound
License: LGPLv2.1
Url: http://www.%name.org

Source: http://downloads.sourceforge.net/%name/%name-%version.tar.bz2
Source1: mp3license

Requires: libmpg123 = %version-%release

%ifarch %ix86
%define wcpu i586
%else
%ifarch x86_64
%define wcpu x86-64
%else
%define wcpu generic
%endif
%endif

BuildRequires: libalsa-devel
%{?_with_nas:BuildRequires: libaudio-devel}
%{?_with_sdl:BuildRequires: libSDL_sound-devel libSDL-devel}
%{?_with_pulse:BuildRequires: libpulseaudio-devel}

%description
Mpg123 is a fast, free and portable MPEG audio player for Unix.
It supports MPEG 1.0/2.0 layers 1, 2 and 3 ("mp3" files).  For
full CD quality playback (44 kHz, 16 bit, stereo) a fast CPU
is required. Mono and/or reduced quality playback (22 kHz or
11 kHz) is possible on slow CPUs (like Intel 486).

For information on the MP3 License, please visit:
%url


%package -n libmpg123
Summary: mpg123 library
Group: System/Libraries
Provides: libmpg123

%description -n libmpg123
This package provides mpg123 library.

%package -n libmpg123-devel
Summary: mpg123 library headers
Group:  Development/C
Requires: libmpg123 = %version-%release

%description -n libmpg123-devel
This package provides mpg123 library headers


%prep
%setup
install -p -m644 %SOURCE1 .

%build
%autoreconf
%add_optflags %optflags_shared
%configure \
	--with-audio="%mods" \
	--with-optimization=0 \
	--enable-network=yes \
	--with-cpu=%{wcpu}
%make_build CFLAGS="%optflags -Wformat -Werror=format-security"

%install
%makeinstall_std
mkdir -p %buildroot%_defaultdocdir/%name-%version/
%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README mp3license doc/

%_bindir/%name
%_bindir/%name-id3dump
%_bindir/%name-strip
%_bindir/out123
%_man1dir/%name.1.*
%_man1dir/out123.1.*
%dir %_libdir/%name
%_libdir/%name/*.so

%files -n libmpg123
%_libdir/libmpg123.so.*
%_libdir/libout123.so.*
%doc NEWS.lib%name

%files -n libmpg123-devel
%_libdir/libmpg123.so
%_libdir/libout123.so
%_pkgconfigdir/lib%name.pc
%_pkgconfigdir/libout123.pc
%_includedir/*.h


%changelog
