Name: 	  nagwad
Version:  0.9.12
Release:  alt2

Summary:  Nagios watch daemon
License:  GPLv3
Group:    Monitoring
Url: 	  http://git.altlinux.org/people/nbr/packages/nagwad.git


Source:   %name-%version.tar

BuildArch: noarch
BuildRequires: discount

Requires:  systemd audit
Requires:  osec-cronjob
Requires:  nagios-nrpe >= 3.2.1-alt4

%description
Daemon that listens to journald and generates alerts based on journal messages
Example configuration works with alterator-ports-access. It provides Nagios
alerts when unauthorized USB devices are inserted.

%prep
%setup

%package templates
Summary: Nagios templates for a nagwad node
Group:   Monitoring
Obsoletes: %name-server
Conflicts: %name-server
Conflicts: nagios < 3.0.6-alt9
Requires: xvt openssh-clients

%description templates
These are Nagios configuration templates for monitoring a nagwad-node.

%package actions
Summary: Nagstamon actions for a nagwad node
Group:   Monitoring
Requires: xvt openssh-clients

%description actions
These are Nagstamon action commands suitable for a nagwad-node.

%build

markdown -f links,smarty,toc,autolink -o signal.html signal.md

%install
install -Dm 0755 scripts/nsca-shell %buildroot%_bindir/nsca-shell
install -Dm 0755 scripts/nagwad %buildroot%_sbindir/nagwad
install -Dm 0755 scripts/nrpe/check_nagwad %buildroot/%_libexecdir/nagios/plugins/check_nagwad
install -Dm 0755 scripts/nrpe/check_osec %buildroot/%_libexecdir/nagios/plugins/check_osec

install -Dm 0644 conf/audit/rules.d/50-nagwad.rules %buildroot%_sysconfdir/audit/rules.d/50-nagwad.rules
install -Dm 0644 conf/nagios/templates/50-nagwad.cfg %buildroot%_sysconfdir/nagios/templates/50-nagwad.cfg
install -Dm 0644 conf/nagwad/audit.regexp %buildroot%_sysconfdir/nagwad/audit.regexp
install -Dm 0644 conf/nagwad/authdata.regexp %buildroot%_sysconfdir/nagwad/authdata.regexp
install -Dm 0644 conf/nagwad/device.regexp %buildroot%_sysconfdir/nagwad/device.regexp
install -Dm 0644 conf/nagwad/login.regexp %buildroot%_sysconfdir/nagwad/login.regexp
install -Dm 0644 conf/nagwad/osec.regexp %buildroot%_sysconfdir/nagwad/osec.regexp
install -Dm 0644 conf/nagwad/print.regexp %buildroot%_sysconfdir/nagwad/print.regexp
install -Dm 0644 conf/nagios/nrpe/nagwad.cfg %buildroot%_sysconfdir/nagios/nrpe-commands/nagwad.cfg
install -Dm 0644 conf/nagstamon/actions/action_Lock_host.conf %buildroot%_sysconfdir/nagstamon/actions/action_Lock_host.conf
install -Dm 0644 conf/nagstamon/actions/action_NSCA_shell.conf %buildroot%_sysconfdir/nagstamon/actions/action_NSCA_shell.conf

install -Dm 0644 unit/nagwad.service %buildroot/%_unitdir/nagwad.service

mkdir -p %buildroot/var/log/nagwad

%pre

if [ -e %_sysconfdir/nagwad/audit/audit.regexp ]; then
    cp -nv %_sysconfdir/nagwad/audit/audit.regexp \
       %_sysconfdir/nagwad/audit.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/authdata/authdata.regexp ]; then
    cp -nv %_sysconfdir/nagwad/authdata/authdata.regexp \
       %_sysconfdir/nagwad/authdata.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/device/device.regexp ]; then
    cp -nv %_sysconfdir/nagwad/device/device.regexp \
       %_sysconfdir/nagwad/device.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/login/login.regexp ]; then
    cp -nv %_sysconfdir/nagwad/login/login.regexp \
       %_sysconfdir/nagwad/login.regexp ||:
fi
if [ -e %_sysconfdir/nagwad/osec/osec.regexp ]; then
    cp -nv %_sysconfdir/nagwad/osec/osec.regexp \
       %_sysconfdir/nagwad/osec.regexp ||:
fi

%files
%doc README.md signal.html signal.md
%_bindir/nsca-shell
%_sbindir/nagwad
%_unitdir/nagwad.*
%_libexecdir/nagios/plugins/*
%_sysconfdir/nagwad
%config(noreplace) %_sysconfdir/audit/rules.d/*nagwad*.rules
%config(noreplace) %_sysconfdir/nagwad/*.regexp
%config(noreplace) %_sysconfdir/nagios/nrpe-commands/nagwad.cfg
/var/log/nagwad

%files templates
%doc README.md signal.html signal.md
%config(noreplace) %_sysconfdir/nagios/templates/*nagwad*.cfg

%files actions
%config(noreplace) %_sysconfdir/nagstamon/actions/*.conf

%changelog
