Name: nedit
Version: 5.5
#%%define rc_ver RC2
Release: alt5.git20121025
%define srcname %name-%version%{?rc_ver:%rc_ver}%{?!rc_ver:-src}

Summary: A text editor for the X Window System
License: GPL
Group: Editors
Url: http://www.nedit.org/
Packager: Dmitry V. Levin <ldv@altlinux.org>

# git://git.code.sf.net/p/nedit/git
Source: %srcname.tar
Source1: %name.desktop
Source2: %name-16x16.png
Source3: %name-32x32.png
Source4: %name-48x48.png

# Automatically added by buildreq on Tue May 23 2006
BuildRequires: libX11-devel libXext-devel libXmu-devel libXp-devel

BuildPreReq: perl-podlators lesstif-devel

%description
NEdit is a multi-purpose text editor for the X Window System, which combines a
standard, easy to use, graphical user interface with the thorough functionality
and stability required by users who edit text eighthours a day.  It provides
intensive support for development in a wide variety of languages, text processors,
and other tools, but at the same time can be used productively by just about anyone
who needs to edit text.

%prep
%setup %{?rc_ver:-n %srcname}

# Change nedit.shell default from /bin/csh to /bin/sh.
find doc -type f -print0 |
	xargs -r0 grep -FZl /bin/csh |
	xargs -r0 subst -p s,/bin/csh,/bin/sh,g --
find -type f -name \*.h -print0 |
	xargs -r0 grep -FZl /bin/csh |
	xargs -r0 subst -p s,/bin/csh,/bin/sh,g --
find -type f -name \*.c -print0 |
	xargs -r0 grep -FZl /bin/csh |
	xargs -r0 subst -p 's,"/bin/csh","/bin/sh",g' --

%build
%make -C doc all

%add_optflags -DBUILD_UNTESTED_NEDIT -DBUILD_BROKEN_NEDIT
%make_build linux YACC='bison -y'
cp -p doc/nedit.{doc,txt}
bzip2 -9f doc/{faq,nedit}.txt

%install
install -pD -m755 source/%name %buildroot%_bindir/%name
install -pD -m755 source/nc %buildroot%_bindir/nedit-client
install -pD -m644 doc/%name.man %buildroot%_man1dir/%name.1
install -pD -m644 doc/nc.man %buildroot%_man1dir/nedit-client.1
install -pD -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE4 %buildroot%_liconsdir/%name.png

%files
%_x11bindir/*
%_x11mandir/man?/*
%_desktopdir/%name.desktop
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png
%doc README ReleaseNotes doc/NEdit.ad doc/*.txt.bz2

%changelog
