Name:           nethack
License:        NetHack General Public License
Group:          Games/Adventure 
Version:        3.4.3
%define ver	343
Release:        alt1.qa1
Summary:        Character Based RPG
Source0:        %name-%ver-src.tar.bz2
Source1:        SuSE.tar.bz2
Patch0:         %name-config.patch
Patch1:         %name-decl.patch
Patch2:         %name-misc.patch
Patch3:         %name-syscall.patch
Patch5:         %name-gzip.patch
URL:            http://www.nethack.org/
Packager: Fr. Br. George <george@altlinux.ru>

# Automatically added by buildreq on Sun Jun 17 2007
BuildRequires: flex libncurses-devel
%add_findreq_skiplist %_libdir/nethack/recover-helper

%description
This RPG is somewhat cryptic with its character based output. But a
true fan knows and appreciates its complexity and possibilities.

This package contains the text interface.



Authors:
--------
    Stephen L. Ericksen <stevee@cc.usu.edu>

%prep
%setup
%patch0
%patch1
%patch2
%patch3
%patch5
tar xvf %SOURCE1
#sed -i "s/^CFLAGS.*/& $RPM_OPT_FLAGS/" sys/unix/Makefile*

%build
# create symlinks to makefiles
sh sys/unix/setup.sh 1
# tty
make clean
cp -f SuSE/tty/config.h include/config.h
cp -f SuSE/tty/Makefile.src src/Makefile
make nethack CFLAGS="$RPM_OPT_FLAGS -I../include -D_GNU_SOURCE"
cp dat/options dat/options.tty
# doc, data, recover...
make Guidebook data oracles options quest.dat rumors dungeon spec_levs check-dlb x11tiles pet_mark.xbm rip.xpm mapbg.xpm
cd util && make CFLAGS="$RPM_OPT_FLAGS -I../include -D_GNU_SOURCE" recover

%install
rm -rf $RPM_BUILD_ROOT
# direcotries
install -d $RPM_BUILD_ROOT%_libdir/nethack/
install -d $RPM_BUILD_ROOT%_gamesbindir
install -d $RPM_BUILD_ROOT%_datadir/games/nethack
install -d $RPM_BUILD_ROOT/%_mandir/man6/
# game directory
install -d $RPM_BUILD_ROOT/var/games/nethack/save
touch $RPM_BUILD_ROOT/var/games/nethack/perm \
        $RPM_BUILD_ROOT/var/games/nethack/record \
        $RPM_BUILD_ROOT/var/games/nethack/logfile
chmod -R 0775 $RPM_BUILD_ROOT/var/games/nethack
# binaries 
install -m 2755 src/nethack.tty $RPM_BUILD_ROOT%_libdir/nethack/
# scripts
for STYLE in tty ; do 
    install -m 755 SuSE/$STYLE/nethack.sh $RPM_BUILD_ROOT%_gamesbindir/nethack.$STYLE
    if [ -r SuSE/$STYLE/nethack-tty.sh ] ; then
        install -m 755 SuSE/$STYLE/nethack-tty.sh $RPM_BUILD_ROOT%_gamesbindir/nethack.tty.$STYLE
    fi
done
# options
install -m 644 dat/options.tty $RPM_BUILD_ROOT%_libdir/nethack/
# man pages
install -m 644 doc/{nethack,lev_comp,dlb,dgn_comp,recover}.6 $RPM_BUILD_ROOT/%_mandir/man6/
# doc
mkdir -p $RPM_BUILD_ROOT/%_defaultdocdir/nethack
install -m 644 doc/Guidebook.{tex,txt} $RPM_BUILD_ROOT/%_defaultdocdir/nethack
cd doc
tar cvfj $RPM_BUILD_ROOT/%_defaultdocdir/nethack/fixes.tar.bz2 fixes*
cd ..
chmod 644 $RPM_BUILD_ROOT/%_defaultdocdir/nethack/fixes.tar.bz2
install -m 644 dat/license $RPM_BUILD_ROOT/%_defaultdocdir/nethack
install -m 644 SuSE/README.SuSE $RPM_BUILD_ROOT/%_defaultdocdir/nethack
# common data
for file in nhdat x11tiles pet_mark.xbm rip.xpm mapbg.xpm license;
do 
  install -m 644 dat/$file  $RPM_BUILD_ROOT%_datadir/games/nethack/
done
# configs
install -m 755 -d $RPM_BUILD_ROOT%_sysconfdir/nethack
for STYLE in tty ; do 
    install -m 755 SuSE/$STYLE/nethackrc $RPM_BUILD_ROOT%_sysconfdir/nethack/nethackrc.$STYLE
done
# main launcher script
install -m 755 SuSE/nethack $RPM_BUILD_ROOT%_gamesbindir/
# recover helper
install -m 755 SuSE/recover-helper $RPM_BUILD_ROOT%_libdir/nethack/
# utils
install -m 755 util/{dgn_comp,dlb,lev_comp,makedefs,recover,tile2x11} $RPM_BUILD_ROOT%_libdir/nethack/
#install -m 755 util/tilemap $RPM_BUILD_ROOT%_libdir/nethack/
# x11 app-defaults
#mkdir -p $RPM_BUILD_ROOT/usr/X11R6/lib/X11/app-defaults
#install -m 644 win/X11/NetHack.ad $RPM_BUILD_ROOT/usr/X11R6/lib/X11/app-defaults/NetHack
# x11 font
#/usr/bin/X11/bdftopcf -o nh10.pcf win/X11/nh10.bdf
#mkdir -p $RPM_BUILD_ROOT/usr/X11R6/lib/X11/fonts/misc/
#install -m 644 nh10.pcf $RPM_BUILD_ROOT/usr/X11R6/lib/X11/fonts/misc/
#gzip $RPM_BUILD_ROOT/usr/X11R6/lib/X11/fonts/misc/nh10.pcf
# the font is added into fonts.dir by SuSEconfig.fonts

%post
#%%run_permissions
#
%verifyscript
#%%verify_permissions -e %_libdir/nethack/nethack.tty

%files
%attr(02711,games,games) %_libdir/nethack/nethack.tty
%_libdir/nethack/options.tty
%_gamesbindir/nethack*.tty
%config %_sysconfdir/nethack/nethackrc.tty
%dir %_sysconfdir/nethack
%dir %_libdir/nethack
%_datadir/games/nethack
%_libdir/nethack/recover-helper
%_libdir/nethack/dgn_comp
%_libdir/nethack/dlb
%_libdir/nethack/lev_comp
%_libdir/nethack/makedefs
%_libdir/nethack/recover
%_libdir/nethack/tile2x11
#%_libdir/nethack/tilemap
%_defaultdocdir/nethack
%_mandir/man6/*
%attr(-,games,games) /var/games/nethack
%_gamesbindir/nethack

%changelog
