%define vulturesdir %_datadir

Name: nethack-vultures
Version: 2.1.2
Release: alt3
Summary: NetHack - Vulture's Eye and Vulture's Claw

Group: Games/Adventure 
License: NetHack General Public License
Url: http://www.darkarts.co.za/projects/vultures/
Source0: http://www.darkarts.co.za/projects/vultures/downloads/vultures-%version/vultures-%version-full.tar.bz2
Patch0: %name-1.11.0-optflags.patch
Patch1: %name-2.1.2-config.patch
Patch2: %name-1.10.1-clawguide.patch
Patch3: %name-2.1.2-tabfullscreen.patch
Patch4: %name-2.1.2-fixbuild.patch
Patch5: %name-desktop.patch
Patch6: format-fix.patch
Patch7: parser-fix.patch
Patch8: vultures-2.1.2-alt-libpng15.patch

Requires: %name-data = %version-%release

# Automatically added by buildreq on Mon Jun 18 2007
BuildRequires: flex libSDL-devel libSDL_image-devel libSDL_mixer-devel libSDL_ttf-devel libncurses-devel libpng-devel desktop-file-utils

BuildRequires:  hardlink

%description
Vulture's Eye is a mouse-driven interface for NetHack that enhances
the visuals, audio and accessibility of the game, yet retains all the
original gameplay and game features.  Vulture's Eye is based on
Falcon's Eye, but is greatly extended.  Also included is Vulture's
Claw, which is based on the Slash'Em core.

%package data
Summary: Data files for NetHack - Vulture's Eye and Vulture's Claw games
Group: Games/Adventure 
BuildArch: noarch

%description data
Data files for Vulture's Eye and Vulture's Claw games.

%prep
%setup -q -n vultures-%version
%patch0 -p1
%patch1 -p1
%patch2
%patch3 -p1
%patch4 -p1
%patch5 -p0
%patch6 -p0
%patch7 -p0
%patch8 -p2
sed -i -e 's|/usr/games/lib/nethackdir|%vulturesdir/vultureseye|g' \
    nethack/doc/{nethack,recover}.6 nethack/include/config.h
sed -i -e 's|/var/lib/games/nethack|%_var/games/vultureseye|g' \
    nethack/include/unixconf.h
sed -i -e 's|/usr/games/lib/nethackdir|%vulturesdir/vulturesclaw|g' \
    slashem/doc/{nethack,recover}.6 slashem/include/config.h
sed -i -e 's|/var/lib/games/nethack|%_var/games/vulturesclaw|' \
    slashem/include/unixconf.h
for N in dist/unix/desktop/*.desktop; do \
    sed -i -e '/Categories=/s/=.*/=Game;RolePlaying;/' $N; done

%build
# Note: no %{?_smp_mflags} in any of these: various parallel build issues.
for i in nethack slashem ; do
    make $i/Makefile
    make -C $i
    make -C $i/util recover dlb dgn_comp lev_comp
    make -C $i/dat spec_levs quest_levs
done

%install
make -C nethack install CHGRP=: CHOWN=: \
    GAMEDIR=$RPM_BUILD_ROOT%vulturesdir/vultureseye \
    VARDIR=$RPM_BUILD_ROOT%_var/games/vultureseye \
    SHELLDIR=$RPM_BUILD_ROOT%_bindir
make -C slashem install CHGRP=: CHOWN=: \
    GAMEDIR=$RPM_BUILD_ROOT%vulturesdir/vulturesclaw \
    VARDIR=$RPM_BUILD_ROOT%_var/games/vulturesclaw \
    SHELLDIR=$RPM_BUILD_ROOT%_bindir

install -dm 755 $RPM_BUILD_ROOT%_mandir/man6
install -pm 644 nethack/doc/nethack.6 \
    $RPM_BUILD_ROOT%_mandir/man6/vultureseye.6
install -pm 644 nethack/doc/recover.6 \
    $RPM_BUILD_ROOT%_mandir/man6/vultureseye-recover.6
install -pm 644 slashem/doc/nethack.6 \
    $RPM_BUILD_ROOT%_mandir/man6/vulturesclaw.6
install -pm 644 slashem/doc/recover.6 \
    $RPM_BUILD_ROOT%_mandir/man6/vulturesclaw-recover.6

install -dm 755 $RPM_BUILD_ROOT%_datadir/icons/hicolor/48x48/apps
for i in vultureseye vulturesclaw ; do
    desktop-file-install \
        --vendor="" \
        --dir=$RPM_BUILD_ROOT%_datadir/applications \
        --mode=644 \
        dist/unix/desktop/$i.desktop
    mv $RPM_BUILD_ROOT%vulturesdir/$i/*.png \
        $RPM_BUILD_ROOT%_datadir/icons/hicolor/48x48/apps/$i.png
    mv $RPM_BUILD_ROOT%vulturesdir/$i/recover \
        $RPM_BUILD_ROOT%_bindir/$i-recover
done

rm -r $RPM_BUILD_ROOT%vulturesdir/vultureseye/manual
rm -r $RPM_BUILD_ROOT%vulturesdir/vulturesclaw/manual

# hardlink instead
# Save some space
#for f in music sound; do
#    cp $RPM_BUILD_ROOT%vulturesdir/vulturesclaw/$f/* $RPM_BUILD_ROOT%vulturesdir/vultureseye/$f/
#    rm -r $RPM_BUILD_ROOT%vulturesdir/vulturesclaw/$f
#    ln -s ../vultureseye/$f \
#        $RPM_BUILD_ROOT%vulturesdir/vulturesclaw/$f
#done

chmod -s $RPM_BUILD_ROOT%vulturesdir/vultures*/vultures* # for stripping

# Clean up
sed -i -e "s|$RPM_BUILD_ROOT||" $RPM_BUILD_ROOT%_bindir/vultures{eye,claw}
rm $RPM_BUILD_ROOT%vulturesdir/vultures*/*.ico

# viy /usr/share hacks
sed -i -e 's,HACK=$HACKDIR/vulturesclaw,HACK=%_bindir/vulturesclaw.bin,' $RPM_BUILD_ROOT%_bindir/vulturesclaw
sed -i -e 's,HACK=$HACKDIR/vultureseye,HACK=%_bindir/vultureseye.bin,' $RPM_BUILD_ROOT%_bindir/vultureseye
mv $RPM_BUILD_ROOT%vulturesdir/vulturesclaw/vulturesclaw $RPM_BUILD_ROOT%_bindir/vulturesclaw.bin
mv $RPM_BUILD_ROOT%vulturesdir/vultureseye/vultureseye $RPM_BUILD_ROOT%_bindir/vultureseye.bin

# Save quite a bit of space
hardlink -cv $RPM_BUILD_ROOT%vulturesdir/vultures*

%pre
/usr/sbin/groupadd -r vultures 2> /dev/null || :
# eliminate the old graphics directory symlink that was confusing rpm
rm -rf %vulturesdir/vulturesclaw/graphics

%files
%_bindir/vultureseye
%_bindir/vulturesclaw
%_bindir/vultureseye-recover
%_bindir/vulturesclaw-recover
%attr(2711,root,vultures) %_bindir/vultureseye.bin
%attr(2711,root,vultures) %_bindir/vulturesclaw.bin
%defattr(664,root,vultures,775)
%dir %_var/games/vultureseye/
%config(noreplace) %_var/games/vultureseye/record
%config(noreplace) %_var/games/vultureseye/perm
%config(noreplace) %_var/games/vultureseye/logfile
%dir %_var/games/vultureseye/save/
%dir %_var/games/vulturesclaw/
%config(noreplace) %_var/games/vulturesclaw/record
%config(noreplace) %_var/games/vulturesclaw/perm
%config(noreplace) %_var/games/vulturesclaw/logfile
%dir %_var/games/vulturesclaw/save/

%files data
%doc nethack/README nethack/dat/license nethack/dat/history nethack/dat/*help
%doc slashem/readme.txt slashem/history.txt slashem/slamfaq.txt vultures/gamedata/manual/
%dir %vulturesdir/vultureseye/
%vulturesdir/vultureseye/config/
%vulturesdir/vultureseye/defaults.nh
%vulturesdir/vultureseye/graphics/
%vulturesdir/vultureseye/license
%vulturesdir/vultureseye/music/
%vulturesdir/vultureseye/nhdat
%vulturesdir/vultureseye/sound/
%vulturesdir/vultureseye/fonts/
%vulturesdir/vultureseye/tiles/
%dir %vulturesdir/vulturesclaw/
%vulturesdir/vulturesclaw/config/
%vulturesdir/vulturesclaw/defaults.nh
%vulturesdir/vulturesclaw/graphics/
%vulturesdir/vulturesclaw/Guidebook.txt
%vulturesdir/vulturesclaw/license
%vulturesdir/vulturesclaw/music/
%vulturesdir/vulturesclaw/nh*share
%vulturesdir/vulturesclaw/sound/
%vulturesdir/vulturesclaw/fonts/
%vulturesdir/vulturesclaw/tiles/
%_datadir/applications/*vultures*.desktop
%_liconsdir/vultures*.png
%_mandir/man6/vultures*.6*

%changelog
