Name: nginx
Summary: Fast HTTP server
Version: 1.26.2
Release: alt1
License: BSD
Group: System/Servers
BuildRequires: libpcre2-devel libssl-devel perl-devel zlib-devel libkrb5-devel
BuildRequires: libGeoIP-devel
BuildRequires: libgd2-devel
BuildRequires: libpam-devel
BuildRequires: libxml2-devel libxslt-devel
%def_with perl
%def_with accept_language
%def_with aio
%def_with aio
%def_with image_filter
%def_with xslt
%def_without debug
%def_with geoip
%def_with geoip2
%def_with push_stream
%def_with spnego
%def_enable cache_purge
%def_enable rtmp
%define modpath %_libdir/%name
Url: https://nginx.org
VCS: https://trac.nginx.org/nginx/browser/nginx
# R/O git mirror https://github.com/nginx/nginx
Source: %url/%name-%version.tar
Source1: %name.conf.in
Source2: %name.init
Source3: %name.logrotate.in
Source5: %name.sysconfig
Source6: default.conf
Source7: cache_purge.tar
Source9: %name.service
Source10: nginx-rtmp-module.tar
Source11: mime.types
Source12: nginx.filetrigger
Source13: ngx_http_auth_pam_module.tar
Source14: spnego-http-auth-nginx-module.tar
Source15: nginx-accept_language-module.tar
Source16: nginx-push-stream-module.tar
Source17: nginx-geoip2-module.tar
Source100: %name.watch

Patch0: cache-purge-fix-compatibility.patch

Requires(pre): shadow-utils
Requires(post): sed
Provides: webserver
%define nginx_user _nginx
%define nginx_group _nginx
%define nginx_etc %_sysconfdir/%name
%define nginx_spool %_spooldir/%name
%define nginx_log %_logdir/%name
%define configs %buildroot{%_unitdir/%name.service,%_sysconfdir/logrotate.d/%name,%nginx_etc/{%name.conf,sites-available.d/default.conf}}

%if_with geoip
%package geoip
Summary: GeoIP module for nginx
Group: System/Servers
Requires: GeoIP-Lite-City GeoIP-Lite-Country
Requires: %name = %EVR

%description geoip
GeoIP module for nginx
%endif

%if_with geoip2
%package geoip2
Summary: GeoIP2 module for nginx
Group: System/Servers
Requires: %name = %EVR
BuildRequires: libmaxminddb-devel

%description geoip2
ngx_http_geoip2_module - creates variables with values from the maxmind geoip2
databases based on the client IP (default) or from a specific variable
(supports both IPv4 and IPv6)
%endif

%if_with accept_language
%package accept_language
Summary: Nginx Accept Language module
Group: System/Servers
Requires: %name = %EVR

%description accept_language
This module parses the Accept-Language header and gives the most suitable locale
for the user from a list of supported locales from your website.
%endif

%if_with image_filter
%package image_filter
Summary: image_filter module for nginx
Group: System/Servers
Requires: %name = %EVR

%description image_filter
image_filter module for nginx
%endif

%package pam
Summary: auth_pam module for nginx.
Group: System/Servers
%def_with auth_pam
Requires: %name = %EVR

%description pam
auth_pam module for nginx.

%if_with perl
%package perl
Summary: Perl for nginx
Group: System/Servers
Requires: %name = %EVR

%description perl
Perl for nginx
%endif

%if_with push_stream
%package push_stream
Summary: Nginx Push Stream Module
Group: System/Servers
Requires: %name = %EVR

%description push_stream
A pure stream http push technology for your Nginx setup.
%endif

%package spnego
Summary: Simple and Protected GSSAPI Negotiation Mechanism for nginx
Group: System/Servers
%def_with spnego
Requires: %name = %EVR

%description spnego
Simple and Protected GSSAPI Negotiation Mechanism for nginx

%package xslt
Summary: XSLT module for nginx
Group: System/Servers
%def_with xslt
Requires: %name = %EVR

%description xslt
XSLT module for nginx

%description
Fast HTTP server, extremely useful as an Apache frontend


%prep
%setup -a7 -a10 -a13 -a14 -a15 -a16 -a17
sed -i 's/INSTALLSITEMAN3DIR=.*/INSTALLDIRS=vendor/' auto/lib/perl/make
cp -f %SOURCE11 conf/mime.types

pushd cache_purge
%patch0 -p1
popd

%build
./configure \
	--prefix=/ \
	--conf-path=%nginx_etc/nginx.conf \
	--sbin-path=%_sbindir \
        --modules-path=%modpath \
	--error-log-path=%nginx_log/nginx.error.log \
	--http-log-path=%nginx_log/nginx.log \
	--http-client-body-temp-path=%nginx_spool/tmp/client \
	--http-proxy-temp-path=%nginx_spool/tmp/proxy \
	--http-fastcgi-temp-path=%nginx_spool/tmp/fastcgi \
	--http-uwsgi-temp-path=%nginx_spool/tmp/uwsgi \
	--http-scgi-temp-path=%nginx_spool/tmp/scgi \
	--pid-path=%_var/run/nginx.pid \
	--user=%nginx_user \
	--group=%nginx_group \
	--with-http_ssl_module \
	--with-select_module    \
	--with-poll_module      \
        --with-threads \
%if_with aio
	--with-file-aio		\
%endif
	--with-http_ssl_module  \
	--with-http_v2_module  \
	--with-http_realip_module \
	--with-http_addition_module \
%if_with xslt
	--with-http_xslt_module=dynamic \
%endif
%if_with image_filter
	--with-http_image_filter_module=dynamic \
%endif
%if_with geoip
	--with-http_geoip_module=dynamic \
%endif
%if_with geoip2
	--add-dynamic-module=nginx-geoip2-module \
%endif
%if_with accept_language
	--add-dynamic-module=nginx-accept_language-module \
%endif
%if_with spnego
	--add-dynamic-module=spnego-http-auth-nginx-module \
%endif
%if_with auth_pam
	--add-dynamic-module=ngx_http_auth_pam_module \
%endif
%if_with push_stream
	--add-dynamic-module=nginx-push-stream-module \
%endif
	--with-http_sub_module \
	--with-http_dav_module \
	--with-http_flv_module \
	--with-http_mp4_module \
	--with-http_gunzip_module \
	--with-http_gzip_static_module \
	--with-http_auth_request_module \
        --with-http_random_index_module \
	--with-http_secure_link_module \
	--with-http_degradation_module \
	--with-http_slice_module \
	--with-http_stub_status_module \
%if_with perl
	--with-http_perl_module=dynamic \
%endif
	--with-mail=dynamic \
	--with-mail_ssl_module \
	--with-stream=dynamic \
	--with-stream_ssl_module \
%if_enabled cache_purge
	--add-module=cache_purge \
%endif
%if_enabled rtmp
	--add-dynamic-module=nginx-rtmp-module \
%endif
%if_with debug
	--with-debug \
%endif
	--with-md5=%_libdir \
	--with-sha1=%_libdir

%make_build DESTDIR=%buildroot

%install
mkdir -p %buildroot{%nginx_etc,%_sysconfdir/logrotate.d,%_sbindir,%nginx_spool/tmp,%nginx_log}
mkdir -p %buildroot%_spooldir/nginx/tmp/{client,proxy,fastcgi,scgi,uwsgi}
mkdir -p %buildroot%_lockdir/%name
mkdir -p %buildroot%nginx_etc/sites-enabled.d
mkdir -p %buildroot%nginx_etc/sites-available.d
mkdir -p %buildroot%nginx_etc/conf-enabled.d
mkdir -p %buildroot%nginx_etc/conf-available.d
%makeinstall DESTDIR=%buildroot
rm -f %buildroot%nginx_etc/%name.conf
install -pD -m644 %SOURCE1 %buildroot%nginx_etc/%name.conf
install -pD -m755 %SOURCE2 %buildroot%_initdir/%name
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/%name
install -pD -m644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m644 %SOURCE6 %buildroot%nginx_etc/sites-available.d/default.conf
install -pD -m644 %SOURCE9 %buildroot%_unitdir/%name.service
install -pD -m644 nginx-rtmp-module/stat.xsl %buildroot%nginx_etc/stat.xsl
subst s!@nginx_user@!%nginx_user!g %configs
subst s!@nginx_etc@!%nginx_etc!g %configs
subst s!@nginx_spool@!%nginx_spool!g %configs
subst s!@nginx_log@!%nginx_log!g %configs
mkdir -p %buildroot%_docdir/%name-%version
cp -a CHANGES CHANGES.ru %buildroot%_docdir/%name-%version/
%if_with uwsgi
install -pD -m644 uwsgi/uwsgi_params %buildroot%nginx_etc/
%endif
rm -rf %buildroot/html/
mkdir -p %buildroot%nginx_etc/modules-available.d
mkdir -p %buildroot%nginx_etc/modules-enabled.d
for s in %buildroot/%modpath/*.so; do
    fn=${s##*/}
    module=${fn%%.so}
    module=${module#ngx_}
    module=${module%%_module}
    echo "load_module %modpath/$fn;" >> %buildroot%nginx_etc/modules-available.d/$module.conf
done
echo "# load dynamic nginx modules" > %buildroot%nginx_etc/nginx.conf.tmp
echo -e "include /etc/nginx/modules-enabled.d/*.conf;\n" >> %buildroot%nginx_etc/nginx.conf.tmp
cat %buildroot%nginx_etc/nginx.conf >> %buildroot%nginx_etc/nginx.conf.tmp
mv -f %buildroot%nginx_etc/nginx.conf.tmp %buildroot%nginx_etc/nginx.conf
install -pD -m755 %SOURCE12 %buildroot/usr/lib/rpm/nginx.filetrigger

%preun
%preun_service %name

%pre
%_sbindir/groupadd -r -f %nginx_group ||:
%_sbindir/groupadd -r -f _webserver ||:
%_sbindir/useradd -r -g %nginx_group -G _webserver -d /dev/null -s /dev/null -n %nginx_user \
	2> /dev/null > /dev/null ||:

%post
sed -i 's/\(types_hash_bucket_size[[:space:]]*\)[[:space:]]32[[:space:]]*;[[:space:]]*$/\1 64;/' /etc/nginx/nginx.conf ||:

%files
%_rpmlibdir/nginx.filetrigger
%_initdir/*
%_sbindir/*
%dir %nginx_etc
%dir %nginx_etc/sites-enabled.d
%dir %nginx_etc/sites-available.d
%dir %nginx_etc/modules-enabled.d
%dir %nginx_etc/modules-available.d
%dir %nginx_etc/conf-enabled.d
%dir %nginx_etc/conf-available.d
%config(noreplace) %nginx_etc/modules-available.d/mail.conf
%config(noreplace) %nginx_etc/modules-available.d/stream.conf
%config(noreplace) %nginx_etc/sites-available.d/default.conf
%if_enabled rtmp
%config(noreplace) %nginx_etc/modules-available.d/rtmp.conf
%nginx_etc/stat.xsl
%endif
%dir %attr(0700,root,root) %_lockdir/%name
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp/client
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp/proxy
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp/fastcgi
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp/scgi
%dir %attr(1770,root,%nginx_group) %nginx_spool/tmp/uwsgi
%dir %attr(1770,root,%nginx_group) %nginx_spool
%dir %attr(1770,root,%nginx_group) %nginx_log
%config(noreplace) %nginx_etc/mime.types
%config(noreplace) %nginx_etc/nginx.conf
%config(noreplace) %nginx_etc/fastcgi.conf
%config(noreplace) %nginx_etc/scgi_params
%config(noreplace) %nginx_etc/uwsgi_params
%config(noreplace) %nginx_etc/fastcgi_params
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_unitdir/%name.service
%nginx_etc/*.default
%nginx_etc/koi-win
%nginx_etc/koi-utf
%nginx_etc/win-utf
%_docdir/%name-%version
%if_with uwsgi
%config(noreplace) %nginx_etc/uwsgi_params
%endif
%dir %modpath
%modpath/ngx_mail_module.so
%modpath/ngx_stream_module.so
%if_enabled rtmp
%modpath/ngx_rtmp_module.so
%endif

%files geoip
%config(noreplace) %nginx_etc/modules-available.d/http_geoip.conf
%modpath/ngx_http_geoip_module.so

%if_with geoip2
%files geoip2
%config(noreplace) %nginx_etc/modules-available.d/http_geoip2.conf
%config(noreplace) %nginx_etc/modules-available.d/stream_geoip2.conf
%modpath/ngx_http_geoip2_module.so
%modpath/ngx_stream_geoip2_module.so
%endif

%if_with image_filter
%files image_filter
%config(noreplace) %nginx_etc/modules-available.d/http_image_filter.conf
%modpath/ngx_http_image_filter_module.so
%endif

%if_with accept_language
%files accept_language
%config(noreplace) %nginx_etc/modules-available.d/http_accept_language.conf
%modpath/ngx_http_accept_language_module.so
%endif

%files pam
%config(noreplace) %nginx_etc/modules-available.d/http_auth_pam.conf
%modpath/ngx_http_auth_pam_module.so

%if_with perl
%files perl
%config(noreplace) %nginx_etc/modules-available.d/http_perl.conf
%perl_vendor_archlib/nginx.pm
%perl_vendor_autolib/nginx
%modpath/ngx_http_perl_module.so
%endif

%if_with push_stream
%files push_stream
%config(noreplace) %nginx_etc/modules-available.d/http_push_stream.conf
%modpath/ngx_http_push_stream_module.so
%endif

%files spnego
%config(noreplace) %nginx_etc/modules-available.d/http_auth_spnego.conf
%modpath/ngx_http_auth_spnego_module.so

%files xslt
%config(noreplace) %nginx_etc/modules-available.d/http_xslt_filter.conf
%modpath/ngx_http_xslt_filter_module.so

%changelog
