%define py_geoip_pkg python-module-GeoIP
%define oname nicotine+

Name: nicotine-plus
Version: 1.4.1
Release: alt1

Summary: The client program for the SoulSeek filesharing system
Summary(ru_RU.UTF-8): Клиент для файлообменной сети SoulSeek

Group: Networking/File transfer
License: GPL
Url: https://github.com/Nicotine-Plus/nicotine-plus

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/Nicotine-Plus/nicotine-plus/archive/%version.tar.gz
Source: %oname-%version.tar

Patch: %name-alt-desktop-entry.patch

BuildArch: noarch

Provides: nicotine
Obsoletes: nicotine

# manually removed: eric
# Automatically added by buildreq on Sat May 26 2007
BuildRequires: python-devel python-module-pygobject python-module-pyvorbis python-modules-compiler

BuildPreReq: rpm-build-python

Requires: python-module-sexy python-module-pygtk-libglade

%add_python_req_skip pywintypes win32con win32gui
BuildRequires: desktop-file-utils

# Mozilla does not embedding anymore
%add_python_req_skip gtkmozembed

%description
Nicotine is a feature-complete client for the SoulSeek filesharing network that
is used primarily to share music.

Nicotine supports everything a SoulSeek client is supposed to do, such as
downloading, uploading, searching, chatting, keeping a "buddy" list and has
lots of other features like finding similar users and getting listening
recommendations based on user's preferences.

Nicotine also supports a country code blocker using the GeoIP library.
To enable this functionality install the %py_geoip_pkg package.

Nicotine is a successor to the PySoulSeek project by Alexander Kanavin.

Nicotine supports psyco, an inline optimizer for python code,
you can install it from python-module-psyco package.

%description -l ru_RU.UTF-8
Nicotine -- это полнофункциональный клиент для файлообменной сети SoulSeek,
ориентированной, прежде всего, на обмен музыкой.

Nicotine поддерживает все стандартные для клиента сети SoulSeek функции, такие
как загрузка и пересылка файлов, поиск, чат, ведение списка "друзей", а также
множество других, как, например, поиск похожих пользователей и получение
рекомендаций по музыке на основе пользовательских предпочтений.

Помимо этого, Nicotine умеет блокировать пользователей из определённых стран,
посредством библиотеки GeoIP. Для включения данной функциональности необходимо
дополнительно установить пакет %py_geoip_pkg.

Nicotine является преемником проекта PySoulSeek, который создал Александр Канавин.

Nicotine поддерживает оптимизатор кода psyco, вы можете установить
его из пакета python-module-psyco.

%prep
%setup -n %oname-%version

%build
%python_build

%install
%python_install

%find_lang nicotine

desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=FileTransfer \
	--add-category=P2P \
	%buildroot%_desktopdir/nicotine.desktop

%files -f nicotine.lang
%_bindir/nicotine
%doc %_docdir/nicotine/
%python_sitelibdir/pynicotine/
%python_sitelibdir/nicotine*egg-info
%_desktopdir/*
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/*
%_datadir/nicotine/

%changelog
