Name: nsd
Version: 4.6.1
Release: alt1

Summary: Name Server Daemon
License: BSD
Group: System/Servers
Url: http://www.nlnetlabs.nl/projects/nsd/

Source0: %name-%version.tar
Source1: %name.conf
Source2: %name.service
Source3: example.com.zone
Source4: 0.0.10.zone
Source5: %name.init
Source6: %name.tmpfiles
Source7: %name.service.forking

Patch0: 0001-Enable-control-by-default.patch

BuildRequires: flex bison libevent-devel libssl-devel

%description
NSD is an authoritative only, high performance, simple
and open source name server.

%prep
%setup

%patch0 -p1

%build
%autoreconf
%configure \
  --with-user=_nsd \
  --enable-bind8-stats \
  --enable-zone-stats \
  --enable-ratelimit \
  --enable-root-server \
  --disable-largefile \
  --disable-recvmmsg \
  --with-pidfile=%_runtimedir/%name.pid \
  --with-dbfile=%_localstatedir/%name/%name.db \
  --with-difffile=%_localstatedir/%name/ixfr.db \
  --with-xfrdfile=%_localstatedir/%name/xfrd.state \
  --localstatedir=%_var
%make_build -j1

%install
%makeinstall_std
mkdir -p %buildroot/%systemd_unitdir
mkdir -p %buildroot/%_localstatedir/%name
mkdir -p %buildroot/%_initdir
mv %buildroot/%_sysconfdir/%name/%name.conf.sample .
cp %SOURCE1 %buildroot/%_sysconfdir/%name
cp %SOURCE2 %buildroot/%systemd_unitdir
cp %SOURCE3 %buildroot/%_sysconfdir/%name
cp %SOURCE4 %buildroot/%_sysconfdir/%name
cp %SOURCE5 %buildroot/%_initdir/%name
install -Dpm 644 %SOURCE6 %buildroot%_tmpfilesdir/%name.conf
install -Dpm 644 %SOURCE7 %buildroot%_datadir/%name/examples/%name.service.forking

%pre
/usr/sbin/groupadd -r -f _nsd
/usr/sbin/useradd -r -g _nsd -d /var/empty -s /sbin/nologin -n -c "Name Server Daemon" _nsd >/dev/null 2>&1 ||:

%preun
%preun_service nsd

%post
if [ ! -r %_sysconfdir/%name/nsd_server.pem ]
then # set up TLS certificates for %_sbindir/nsd-control to work
	%_sbindir/nsd-control-setup
fi
%post_service nsd

%files
%_sbindir/*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name/*.zone
%_tmpfilesdir/%name.conf
%systemd_unitdir/%name.service
%_datadir/%name/examples/*
%attr(0755,root,root) %_initdir/%name
%attr(0755,_nsd,_nsd) %dir %_localstatedir/%name
%_man5dir/*
%_man8dir/*
%doc doc contrib %name.conf.sample

%changelog
