Name: openntpd
Version: 3.9p1
Release: alt14

%define privuser  ntpd
%define privgroup ntpd
%define privpath  /var/empty

%def_with setproctitle

Summary: Network daemon for synchronize local clock to remote NTP servers
License: ISC-style
Group: Networking/Other
Url: http://www.openntpd.org

# ftp://ftp.openbsd.org/pub/OpenBSD/OpenNTPD/openntpd-%version.tar.gz
Source0: openntpd-%version.tar
Source1: ntpd.init
Source2: ntpd.control
Source3: ntpd.sysconfig
Source4: ntpd.service
# http://www.zip.com.au/~dtucker/openntpd/patches/openntpd-3.9p1-linux-adjtimex.patch
Patch: openntpd-%version-%release.patch
Patch1: openntpd-3.9p1-alt-openssl1.1.patch

Provides: ntp-server

PreReq: %privpath
Conflicts: ntpd

BuildPreReq: libssl-devel
%{?_with_setproctitle:BuildPreReq: setproctitle-devel}

Summary(ru_RU.UTF-8): Сетевой сервер для синхронизации точного времени

%description
The ntpd daemon synchronizes the local clock to one or more remote NTP
servers, and can also act as an NTP server itself, redistributing the
local time.  It implements the Simple Network Time Protocol version 4,
as described in RFC 2030, and the Network Time Protocol version 3,
as described in RFC 1305.

Here is a portable implementation of OpenNTPD, small reliable NTP daemon
initially designed as part of OpenBSD.

%description -l ru_RU.UTF-8
Демон NTP синхронизирует время в локальных системных часах с внешними
серверами NTP, а также при необходимости сам выступает сервером NTP,
сообщая своё локальное время по сети другим компьютерам.

Данный пакет содержит реализацию NTP-демона, разработанную в рамках
операционной системы OpenBSD, и перенесённую впоследствии на другие
платформы.

%prep
%setup
%patch -p1
%patch1 -p1
bzip2 -9k ChangeLog

%build
%add_optflags -DUSE_ADJTIMEX
%{?_with_setproctitle:export LIBS=-lsetproctitle}
%autoreconf
%configure \
	--with-mantype=doc \
	--with-privsep-user=%privuser \
	--with-privsep-path=%privpath \
	--disable-strip \
	#
%make_build

%install
%makeinstall_std
install -pD -m755 %_sourcedir/ntpd.init %buildroot%_initdir/ntpd
install -pD -m755 %_sourcedir/ntpd.control %buildroot%_controldir/ntpd
install -pD -m640 %_sourcedir/ntpd.sysconfig %buildroot%_sysconfdir/sysconfig/ntpd
install -pD -m644 %_sourcedir/ntpd.service %buildroot%systemd_unitdir/ntpd.service

%pre
/usr/sbin/groupadd -r -f %privgroup
/usr/sbin/useradd -r -s /dev/null -g %privgroup -d %privpath -c 'OpenNTP daemon' %privuser >/dev/null 2>&1 ||:

%post
%post_service ntpd

%preun
%preun_service ntpd

%files
%config(noreplace) %attr(640,root,wheel) %_sysconfdir/ntpd.conf
%config(noreplace) %attr(640,root,wheel) %_sysconfdir/sysconfig/ntpd
%config %_initdir/ntpd
%config %_controldir/ntpd
%systemd_unitdir/ntpd.service
%_sbindir/ntpd
%_mandir/man?/ntpd.*
%doc CREDITS ChangeLog.bz2 LICENCE README

%changelog
