%define        pyagentx_version 0.4.pcs.2

Name: 	       pcs
Epoch:         1
Version:       0.10.5
Release:       alt2
Summary:       Pacemaker/Corosync configuration system
License:       GPLv2+ and MIT
Group:         Other
Url:           https://github.com/ClusterLabs/pcs
Vcs:           https://github.com/ClusterLabs/pcs.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Source1:       pyagentx-v%pyagentx_version.tar.gz
Source2:       pcsd
Source3:       known-hosts
Patch:         compat.patch

%add_python3_req_skip pyagentx
Requires:      python3-module-pcs = %version
Requires:      python3-module-snmp = %version
Obsoletes:     pcs-pcsd < %EVR
Provides:      pcs-pcsd = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-ruby
BuildRequires: corosync fontconfig fonts-ttf-liberation
BuildRequires: python3-devel python3-module-setuptools

%description
Pacemaker/Corosync configuration system with remote access
Pacemaker/Corosync gui/cli configuration system and daemon


%package       -n python3-module-pcs
Summary:       Python module for pacemaker/corosync gui/cli configuration system and daemon
Group:         Other
BuildArch:     noarch
Requires:      %name = %version
Requires:      pacemaker >= 2.0.3-alt2

%description   -n python3-module-pcs
Python module for pacemaker/corosync gui/cli configuration system and daemon


%package       -n python3-module-snmp
Group:         Other
Summary:       Pacemaker cluster SNMP agent
License:       GPLv2 or BSD-2-Clause
Requires:      %name = %EVR
Requires:      pacemaker >= 2.0.3-alt2
Requires:      net-snmp
Obsoletes:     pcs-snmp < %EVR
Provides:      pcs-snmp = %EVR

%description   -n python3-module-snmp
SNMP agent that provides information about pacemaker cluster to the master
agent (snmpd).


%prep
%setup
%patch -p1
sed -e "s,/usr/lib/pcsd/vendor/bundle/ruby,/usr/lib/ruby," -i pcsd/pcsd-ruby.service
mkdir -p pcs/bundled/tmp
tar xf %SOURCE1 -C pcs/bundled/tmp

%build
make BUNDLE_PYAGENTX_SRC_DIR=pcs/bundled/tmp/pyagentx-%pyagentx_version \
     PYAGENTX_LIB_DIR=%buildroot%_libexecdir/pcs/bundled
%ruby_build --use=pcsd --alias=pcs --join=bin:lib

%install
mkdir -p %buildroot%_libexecdir/pcs
mkdir -p %buildroot%_localstatedir/pcsd
mkdir -p %buildroot%_logdir/pcsd
mkdir -p %buildroot%_sysconfdir/sysconfig/
%ruby_install
%makeinstall_std \
     BUNDLE_PYAGENTX_SRC_DIR=pcs/bundled/tmp/pyagentx-%pyagentx_version \
     PYAGENTX_LIB_DIR=%buildroot%_libexecdir/pcs/bundled \
     BUILD_GEMS=false \
     DEST_LIB=%buildroot%_libexecdir \
     SYSTEMCTL_OVERRIDE=true \
     DEST_SYSTEMD_SYSTEM=%buildroot%systemd_unitdir \

install -Dm 0644 pcsd/pcsd.logrotate %buildroot%_logrotatedir/pcsd.logrotate
install -Dm 0755 %SOURCE2 %buildroot%_initdir/pcsd
install -Dm 0644 %SOURCE3 %buildroot%_localstatedir/pcsd/known-hosts

%check
%ruby_test

%post
%post_service pcsd

%preun
%preun_service pcsd

%post          -n python3-module-snmp
%post_service pcs_snmp_agent

%preun         -n python3-module-snmp
%preun_service pcs_snmp_agent


%files
%doc CHANGELOG.md COPYING README.md

%files         -n python3-module-pcs
%doc README.md
%_sbindir/pcs
%python3_sitelibdir_noarch/*
%_man8dir/*.*
%exclude %_man8dir/pcs_snmp_agent.*
%_sysconfdir/bash_completion.d/pcs
%_libexecdir/pcs/pcs_internal
%_sbindir/pcsd
%_initdir/pcsd
%_libexecdir/pcsd
%_sysconfdir/logrotate.d/pcsd
%_sysconfdir/pam.d/pcsd
%_sysconfdir/sysconfig/pcsd
%dir %_logdir/pcsd
%dir %_localstatedir/pcsd
%_logrotatedir/pcsd.logrotate
%systemd_unitdir/pcsd.service
%systemd_unitdir/pcsd-ruby.service
%_localstatedir/pcsd/known-hosts

%files         -n python3-module-snmp
%config(noreplace) %_sysconfdir/sysconfig/pcs_snmp_agent
%_libexecdir/pcs/pcs_snmp_agent
%_libexecdir/pcs/bundled/packages/pyagentx*
%systemd_unitdir/pcs_snmp_agent.service
%_datadir/snmp/mibs/PCMK-PCS*-MIB.txt
%_man8dir/pcs_snmp_agent.*


%changelog
