Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-File-BOM
Version:        0.16
Release:        alt1
Summary:        Utilities for handling Byte Order Marks
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/File-BOM
Source0:        http://www.cpan.org/authors/id/M/MA/MATTLAW/File-BOM-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(Readonly.pm)
BuildRequires:  perl(Symbol.pm)
# Tests only
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Simple.pm)
BuildRequires:  perl(utf8.pm)
Requires:       perl(Encode.pm) >= 1.990
Requires:       perl(Readonly.pm) >= 0.060



Source44: import.info
%filter_from_requires /^perl(Encode.pm)/d
%filter_from_requires /^perl(Readonly.pm)/d

%description
This module provides functions for handling Unicode byte order marks, which
are to be found at the beginning of some files and streams.

%prep
%setup -q -n File-BOM-%{version}
# Normalize EOLs
sed -i -e 's/\r//' README

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} %{buildroot}/*

%check
./Build test

%files
%doc Changes README TODO
%{perl_vendor_privlib}/*

%changelog
