Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %perl_vendor_privlib/Gearman/Task.pm
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Gearman
Version:        2.004.015
Release:        alt1_1
Summary:        Perl interface for Gearman distributed job system
License:        GPL+ or Artistic
URL:            http://danga.com/gearman/
Source0:        https://cpan.metacpan.org/authors/id/P/PA/PALIK/Gearman-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(fields.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IO/Socket/IP.pm)
BuildRequires:  perl(IO/Socket/SSL.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(String/CRC32.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(version.pm)
# Tests:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Which.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Net/EmptyPort.pm)
BuildRequires:  perl(Perl/OSType.pm)
BuildRequires:  perl(Proc/Guard.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/TCP.pm)
BuildRequires:  perl(Test/Timer.pm)
BuildRequires:  perl(vars.pm)
# Optional tests:
%if !%{defined perl_bootstrap}
# Break build cycle: perl-Gearman a.. perl-Gearman-Server a.. perl-Gearman
# perl-Gearman-Server for %%{_bindir}/gearmand
BuildRequires:  perl-Gearman-Server
%endif
# Devel::Gladiator not yet packaged
Requires:       perl(version.pm) >= 0.770

# Remove under-specifed dependencies

Source44: import.info
%filter_from_requires /^perl(version.pm)/d

%description
Gearman provides a generic application framework to farm out work to other
machines or processes that are better suited to do the work. It allows you
to do work in parallel, to load balance processing, and to call functions
between languages. 

%prep
%setup -q -n Gearman-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset AUTHOR_TESTING
make test

%files
%doc CHANGES README TODO
%{perl_vendor_privlib}/Gearman

%changelog
