Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-YAML-Valid
Version:        0.04
Release:        alt2_25
Summary:        Lets you test the validity of YAML files in unit tests
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Test-YAML-Valid
Source0:        https://cpan.metacpan.org/authors/id/J/JR/JROCKWAY/Test-YAML-Valid-%{version}.tar.gz
Patch0:         Test-YAML-Valid-0.04-Fix-building-on-Perl-without-.-in-INC.patch
BuildArch:      noarch
# Module Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
# Dependencies of bundled Module::Install
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(ExtUtils/Manifest.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(JSON.pm)
BuildRequires:  perl(Parse/CPAN/Meta.pm)
BuildRequires:  perl(vars.pm)
# Module Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Builder.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(YAML.pm)
# Test Suite
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(Test/Builder/Tester.pm)
BuildRequires:  perl(Test/More.pm)
# Optional Tests
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(YAML/Syck.pm)
BuildRequires:  perl(YAML/Tiny.pm)
BuildRequires:  perl(YAML/XS.pm)
# Dependencies
# Default backend; can also optionally use YAML::Syck, YAML::Tiny, or YAML::XS
Requires:       perl(YAML.pm) >= 0.600
Source44: import.info

%description
Lets you test the validity of YAML files inside your
(Test::Builder-based) unit tests.

%prep
%setup -q -n Test-YAML-Valid-%{version}

# Fix building on Perl without "." in @INC (CPAN RT#120438)
%patch0 -p1

%build
perl Makefile.PL --skipdeps INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/Test/

%changelog
