Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(LWP/Simple.pm) perl(Test/Deep.pm) perl(Test/Pod.pm) perl(Text/Diff.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl-Filter
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run optional test
%if ! 0%{?rhel}
%bcond_without perl_YAML_LibYAML_enables_optional_test
%else
%bcond_with perl_YAML_LibYAML_enables_optional_test
%endif

Name:           perl-YAML-LibYAML
Epoch:          1
Version:        0.77
Release:        alt1
Summary:        Perl YAML Serialization using XS and libyaml
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/YAML-LibYAML
Source0:        http://www.cpan.org/authors/id/T/TI/TINITA/YAML-LibYAML-%{version}.tar.gz

# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)

# Module
BuildRequires:  perl(B/Deparse.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)

# Tests
BuildRequires:  perl(B.pm)
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Devel/Peek.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(Filter/Util/Call.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(IO/Pipe.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/Builder.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Tie/Array.pm)
BuildRequires:  perl(Tie/Hash.pm)
BuildRequires:  perl(utf8.pm)

%if %{with perl_YAML_LibYAML_enables_optional_test}
# Optional Tests
BuildRequires:  perl(Path/Class.pm)
%endif

# Dependencies
Requires:       perl(B/Deparse.pm)

# libyaml is tweaked and bundled
# https://github.com/ingydotnet/yaml-libyaml-pm/issues/49
# version number determined by comparing commits in upstream repo:
# https://github.com/yaml/libyaml/
Provides:       bundled(libyaml) = 0.2.1

# Avoid provides for perl shared objects

Source44: import.info

%description
Kirill Siminov's "libyaml" is arguably the best YAML implementation. The C
library is written precisely to the YAML 1.1 specification. It was originally
bound to Python and was later bound to Ruby.

%prep
%setup -q -n YAML-LibYAML-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc LICENSE
%doc Changes CONTRIBUTING README
%{perl_vendor_archlib}/auto/YAML/
%{perl_vendor_archlib}/YAML/

%changelog
