Name: postfix
Version: 2.11.11
Release: alt3
Epoch: 1

Summary: Postfix Mail Transport Agent
License: IBM Public License
Group: System/Servers
Url: http://www.postfix.org/

# ftp://ftp.porcupine.org/mirrors/postfix-release/official/postfix-%version.tar.gz
Source: %name-%version.tar.gz

Patch: postfix-%version-%release.patch

%def_with cdb
%def_with ldap
%def_with mysql
%def_with pcre
%def_with pgsql
%def_with sasl
%def_with cyrus
%def_with tls

# Chrooted environment
%define ROOT /var/spool/%name

# Configuration definitions below are here for both customization
# and to simplify building list of files for a package (converting
# postfix-files list to rpm's filelist).

%define _libexecdir /usr/libexec

%define queue_directory %_var/spool/%name
%define config_directory %_sysconfdir/%name

%define plugin_directory %_libdir/%name
%define daemon_directory %_libexecdir/%name
%define data_directory %_localstatedir/%name
%define program_directory %daemon_directory
%define command_directory %_sbindir

%define newaliases_path %_bindir/newaliases
%define mailq_path %_bindir/mailq
%define sendmail_path %_sbindir/sendmail

%define docdir %_docdir/%name-%version
%define manpage_directory %_mandir
%define html_directory %docdir/html
%define readme_directory %config_directory/README_FILES

%define mail_admin mailadm
%define mail_owner postfix
%define setgid_group postdrop
%define default_privs postman

%define restart_flag /var/run/%name.restart
%define libpostfix lib%name-%version.so
%define libpostfix_dict lib%{name}_dict-%version.so

%define _buildaltdir %_builddir/%name-%version/extra

Provides: MTA, MailTransportAgent
Provides: smtpd, smtpdaemon, %name-smtpd
Conflicts: sendmail, masqmail, exim
Obsoletes: %name-beta, %name-smtpd
Requires(pre): sendmail-common >= 1.3, chrooted >= 0.3, %name-control >= 1.6

# This is used to be MDA, but default postfix main.cf uses procmail.
Requires: procmail

BuildPreReq: rpm-build >= 4.0.4-alt0.3, sendmail-common >= 1.3, chrooted >= 0.3
%{?_with_cdb:BuildPreReq: libcdb-devel}
%{?_with_pcre:BuildPreReq: libpcre-devel}
%{?_with_ldap:BuildPreReq: libldap-devel}
%{?_with_mysql:BuildPreReq: libMySQL-devel}
%{?_with_pgsql:BuildPreReq: postgresql-devel}
%{?_with_cyrus:BuildPreReq: libsasl2-devel}
%{?_with_tls:BuildPreReq: libssl-devel}

# Automatically added by buildreq on Fri Oct 31 2003
BuildRequires: groff-base html2text libdb4-devel

%description
Postfix is Wietse Venema's attempt to provide an alternative to the
widely-used Sendmail program.  Postfix attempts to be fast, easy to
administer, and hopefully secure, while at the same time being sendmail
compatible enough to not upset your users.

%package ldap
Summary: LDAP map support for Postfix
Group: System/Servers
Requires: %name = %EVR

%description ldap
This package provides support for LDAP maps in Postfix.

%package mysql
Summary: MySQL map support for Postfix
Group: System/Servers
Requires: %name = %EVR

%description mysql
This package provides support for MySQL maps in Postfix.

%package pcre
Summary: PCRE map support for Postfix
Group: System/Servers
Requires: %name = %EVR

%description pcre
This package provides support for PCRE maps in Postfix.

%package pgsql
Summary: PostgreSQL map support for Postfix
Group: System/Servers
Requires: %name = %EVR

%description pgsql
This package provides support for PostgreSQL maps in Postfix.

%package cyrus
Summary: Cyrus SASL plugin for Postfix
Group: System/Servers
Requires: %name = %EVR

%description cyrus
This package provides Cyrus SASL support for Postfix.

%package dovecot
Summary: Dovecot SASL plugin for Postfix
Group: System/Servers
Requires: %name = %EVR

%description dovecot
This package provides Dovecot SASL support for Postfix.

%package tls
Summary: SSL/TLS support for Postfix
Group: System/Servers
Requires: %name = %EVR

%description tls
This package provides support for SSL/TLS in Postfix.

%package html
Summary: html documentation for Postfix
Group: System/Servers
BuildArch: noarch
Requires: %name = %EVR

%description html
This package provides documentation for Postfix in html format.

%package test-tools
Summary: Postfix testing tools
Group: System/Servers

%description test-tools
Various postfix testing tools

%prep
%setup
%patch -p1

find -type f -print0 |
	xargs -r0 grep -FZl @libdir@ -- |
	xargs -r0 sed -i 's,@libdir@,%_libdir,g' --

%if_with tls
rm -rf src/*-tls
for i in smtp smtpd; do
	cp -a src/$i src/$i-tls
done
%endif #with tls

# Add some makefile targets where appropriate.
sed -i 's/^update /&objs dicts xsasls /' Makefile.in
sed -i 's/^# do not edit below this line/objs: $(OBJS)\n\nobjs-print: objs\n\tls $(OBJS)\n\n&/' \
	src/*/Makefile.in

# Change program names for smtp and smtpd.
sed -i 's/^PROG[[:space:]]*=.*/&-std/' src/{smtp,smtpd}/Makefile.in
%if_with tls
sed -i 's/^PROG[[:space:]]*=.*/&-tls/' src/{smtp,smtpd}-tls/Makefile.in
%endif #with tls

# Remove license, makedefs.out, html documentation, man pages, readme files and sample files from master list.
sed -i '/\(LICENSE\|makedefs\.out\|\(html\|manpage\|readme\|sample\)_directory\)/ d' conf/%name-files
rm -f conf/LICENSE

# Adjust arch-dependent paths.
sed -i s,@LIB@,%_lib, conf/%name-files

# Fix build with util-linux-ng.
sed -i 's/col -bx |/LANG=en_US &/' proto/Makefile.in

# More std/tls tweaks for filelist.
sed -i 's,^.*/\(smtp\|smtpd\),&-std,' conf/%name-files
# comment out tls.*
sed -i 's/[^#]*tls/#&/' conf/%name-files

if [ "%_libexecdir" != "/usr/libexec" ]; then
	find -type f -print0 |
		xargs -r0 grep -FZl /usr/libexec -- |
		xargs -r0 sed -i 's,/usr/libexec,%_libexecdir,g' --
fi

# Create mynetworks and mydestination.
install -pm644 %_buildaltdir/mynetworks conf/
touch conf/mydestination

# Set executable bit on scripts we are going to execute later.
chmod a+x postfix-install %_buildaltdir/*.sh

# Force documentation re-generation
touch -t 01010000 man/*/* html/*

### BUILD ###
%build
OPT="%optflags -fno-strict-aliasing -Wno-comment -Wno-missing-braces"
CCARGS="\
 -DNO_NIS \
 -DDEF_COMMAND_DIR=\\\"%command_directory\\\" \
 -DDEF_CONFIG_DIR=\\\"%config_directory\\\" \
 -DDEF_DAEMON_DIR=\\\"%daemon_directory\\\" \
 -DDEF_DATA_DIR=\\\"%data_directory\\\" \
 -DDEF_PLUGIN_DIR=\\\"%plugin_directory\\\" \
 -DDEF_HTML_DIR=\\\"%html_directory\\\" \
 -DDEF_MAILQ_PATH=\\\"%mailq_path\\\" \
 -DDEF_MANPAGE_DIR=\\\"%manpage_directory\\\" \
 -DDEF_NEWALIAS_PATH=\\\"%newaliases_path\\\" \
 -DDEF_PROGRAM_DIR=\\\"%program_directory\\\" \
 -DDEF_QUEUE_DIR=\\\"%queue_directory\\\" \
 -DDEF_README_DIR=\\\"%readme_directory\\\" \
 -DDEF_SAMPLE_DIR=\\\"%readme_directory\\\" \
 -DDEF_SENDMAIL_PATH=\\\"%sendmail_path\\\" \
"
DICTS=
DICT_LIBS="-ldb"
DICT_ARGS=
SYSLIBS="-lresolv -ldl"
AUXLIBS=

%if_with sasl
# USE_SASL_AUTH is used by smtp, smtpd and xsasl
CCARGS="$CCARGS -DUSE_SASL_AUTH"
%endif #with sasl

%if_with cdb
DICT_ARGS="$DICT_ARGS -DHAS_CDB"
DICT_LIBS="$DICT_LIBS -lcdb"
%endif #with cdb

%if_with ldap
DICT_ARGS="$DICT_ARGS -DHAS_LDAP"
DICTS="$DICTS \$(DICT_LDAP)"
%endif #with ldap

%if_with mysql
DICT_ARGS="$DICT_ARGS -DHAS_MYSQL -I%_includedir/mysql"
DICTS="$DICTS \$(DICT_MYSQL)"
%endif #with mysql

%if_with pcre
DICT_ARGS="$DICT_ARGS -DHAS_PCRE `pcre-config --cflags`"
DICTS="$DICTS \$(DICT_PCRE)"
%endif #with pcre

%if_with pgsql
DICT_ARGS="$DICT_ARGS -DHAS_PGSQL -I%_includedir/pgsql"
DICTS="$DICTS \$(DICT_PGSQL)"
%endif #with pgsql

%if_with tls
# USE_TLS is used by smtp, smtpd, tls and tlsmgr
TLS_ARGS="-DUSE_TLS $(pkg-config libssl --cflags)"
TLS_LIBS='-lssl -lcrypto'
TLS_DIRS='src/tls src/tlsmgr src/tlsproxy src/smtp-tls src/smtpd-tls'
%endif #with tls

## Shared build model; suggested by mjt.
pushd src

# 0. Prepare.
make	-C .. \
	tidy makefiles \
	SYSLIBS="$SYSLIBS" \
	AUXLIBS="$AUXLIBS" \
	CCARGS="$CCARGS $DICT_ARGS -UUSE_TLS" \
	OPT="$OPT" \
	DEBUG=

# 1. build all static libs objects with %optflags_shared.
%make_build -C .. \
	update \
	DEBUG='%optflags_shared' PROG= \
	DIRS='$(LIB_DIRS)'

# 2. separate libs objects into dict-dependent and others.
for a in */*.a; do
	ar t "$a" |
		sed -ne "s,.*,${a%%/*}/&,p"
done | sort -u >postfix_all_obj.list
%_buildaltdir/lorder.sh `cat postfix_all_obj.list` |
	sort -u |
	sort -k2,2 >postfix_lorder.list
printf '%%s\n%%s\n' util/dict_{c,}db.o |
	%_buildaltdir/oclosure.sh postfix_lorder.list >postfix_dict_obj.list
join -v1 postfix_all_obj.list postfix_dict_obj.list >postfix_common_obj.list

# 3. build %libpostfix shared library.
gcc -shared -o ../lib/%libpostfix \
	-Wl,-O1 -Wl,-soname,%libpostfix \
	`cat postfix_common_obj.list` \
	$SYSLIBS
ln -s %libpostfix ../lib/libpostfix.so

# 4. build %libpostfix_dict shared library.
gcc -shared -o ../lib/%libpostfix_dict \
	-Wl,-O1 -Wl,-soname,%libpostfix_dict \
	`cat postfix_dict_obj.list` \
	../lib/libpostfix.so $DICT_LIBS
ln -s %libpostfix_dict ../lib/libpostfix_dict.so

# 5.1 build libtls.a.
%make_build -C .. DIRS=src/tls update

# 5.2 build applications objects.
%make_build -C .. objs

# 6. build dict-dependent applications with %libpostfix and %libpostfix_dict.
dict_build_dirs=
for d in *; do
	[ -f "$d/Makefile" ] || continue
	%_buildaltdir/lorder.sh `cat postfix_dict_obj.list` \
	             `MAKEFLAGS= make -C "$d" -s objs-print |sed -e "s,^,$d/,"` |
		sort -u |
		sort -k2,2 |
		join -1 1 -2 2 -o 2.1 postfix_dict_obj.list - |
		sort -u |join -v1 - postfix_dict_obj.list |
		fgrep -qs "$d"/ || continue
	dict_build_dirs="$dict_build_dirs src/$d"
done
%make_build -C .. \
	LIBS='../../lib/libpostfix_dict.so ../../lib/libpostfix.so ../../lib/libtls.a' \
	DIRS="$dict_build_dirs" \
	SYSLIBS= \
	AUXLIBS= \
	#

# 7. build other applications with %libpostfix only.
%make_build -C .. \
	LIBS=../../lib/libpostfix.so \
	SYSLIBS= \
	AUXLIBS= \
	#

# 8. build dicts.
%make_build -C .. dicts \
	DIRS="src/util src/global" \
	DEBUG='%optflags_shared' \
	LIBS='../../lib/libpostfix_dict.so ../../lib/libpostfix.so' \
	SYSLIBS= \
	AUXLIBS= \
	DICTS="$DICTS" \
	#

# 9. build xsasl plugins.
%if_with sasl
%make_build -C .. xsasls \
	DIRS='src/xsasl' \
	DEBUG='%optflags_shared' \
	LIBS='../../lib/libpostfix.so' \
	SYSLIBS= \
	AUXLIBS= \
	XSASLS='$(XSASL_DOVECOT)%{?_with_cyrus: $(XSASL_CYRUS)}' \
	#
%endif #with sasl

popd # src

# SMP build seems to be broken here.
for d in proto man html; do
	make -C $d -f Makefile.in clobber
done
make manpages

%if_with tls
make	makefiles \
	DIRS="$TLS_DIRS" \
	SYSLIBS= \
	AUXLIBS= \
	CCARGS="$CCARGS $TLS_ARGS" \
	OPT="$OPT" \
	DEBUG=

%make_build \
	DIRS="$TLS_DIRS" \
	LIBS='../../lib/libpostfix_dict.so ../../lib/libpostfix.so ../../lib/libtls.a' \
	SYSLIBS="$TLS_LIBS $DICT_LIBS $SYSLIBS" \
	AUXLIBS= \
	#
%endif #with tls

install -pm644 /usr/share/sendmail-common/aliases conf/
mkdir -p libexec/postqueue
mv bin/postqueue libexec/postqueue/

### INSTALL ###
%install
mkdir -p %buildroot{%ROOT,%_bindir,%_sbindir,%_libdir,%daemon_directory/postqueue,%plugin_directory,%_mandir}

# Install shared libraries and dictionaries.
install -p -m644 lib/%libpostfix lib/%libpostfix_dict %buildroot%_libdir/
install -p -m644 src/*/dict_*.so src/xsasl/xsasl_*.so \
	%buildroot%plugin_directory/ ||:

:>%name.files
# Postfix's postfix-install script accept various parameters both in
# command line and as environment variables.  Better to reset environment
# here, so no locally-set variable will give any surprise.
env -i "LD_LIBRARY_PATH=%buildroot%_libdir" \
	./postfix-install -non-interactive \
		install_root=%buildroot \
		tempdir=%_tmppath

# install testing tools
install bin/*-* %buildroot%_bindir/

# install minimal main.cf
mv %buildroot%config_directory/main.cf{,.dist}
install -pm644 %_buildaltdir/main.cf %buildroot%config_directory/

# prepare for std
for i in smtp smtpd; do
	ln -snf $i-std %buildroot%daemon_directory/$i
done
ln -snf smtp %buildroot%daemon_directory/lmtp

%if_with tls
install -pm755 libexec/{*-tls,tlsmgr,tlsproxy} %buildroot%daemon_directory/
install -pm755 bin/posttls* %buildroot%_bindir/
%endif #with tls

# Finish postqueue install.
chmod 700 %buildroot%daemon_directory/postqueue
ln -rsnf %buildroot%daemon_directory/postqueue/postqueue \
	%buildroot%command_directory/

install -pD -m755 %_buildaltdir/init \
	%buildroot%_initdir/%name
install -pD -m644 %_buildaltdir/%name.service \
	%buildroot%_unitdir/%name.service
install -pD -m755 %_buildaltdir/cron.daily \
	%buildroot%_sysconfdir/cron.daily/%name
install -pD -m750 %_buildaltdir/chroot.lib \
	%buildroot%_sysconfdir/chroot.d/%name.lib
install -pD -m750 %_buildaltdir/chroot.conf \
	%buildroot%_sysconfdir/chroot.d/%name.conf
install -pD -m750 %_buildaltdir/chroot.all \
	%buildroot%_sysconfdir/chroot.d/%name.all
%if_with tls
install -pm755 %_buildaltdir/postfix-generate-ssl-certificate \
	%buildroot%_sbindir/
%endif #with tls

# Install filetrigger.
mkdir -p %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/%name.filetrigger <<'EOF'
#!/bin/sh
LC_ALL=C grep -Fqs %_sbindir/postfix &&
	[ -f %restart_flag ] ||
	exit 0
rm -f %restart_flag
service %name start
exit 0
EOF
chmod 0755 %buildroot%_rpmlibdir/%name.filetrigger

# Install /etc/aliases.
ln -rsnf %buildroot%config_directory/aliases %buildroot%_sysconfdir/

# Install manpages
cp -a man/man{1,5,8} %buildroot%manpage_directory/

# Install qshape and rmail.
install -p -m755 auxiliary/qshape/qshape.pl %buildroot%_bindir/qshape
install -p -m755 auxiliary/rmail/rmail %buildroot%_bindir/

rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir

cp -a html examples *README* COMPATIBILITY HISTORY LICENSE PORTING RELEASE_NOTES \
	%buildroot%docdir/
xz -9 %buildroot%docdir/HISTORY
%if_with tls
mkdir -p %buildroot%docdir/tls
cp -a TLS_* %buildroot%docdir/
xz -9 %buildroot%docdir/TLS_CHANGES
%endif #with tls

install -pm644 IPv6-ChangeLog %buildroot%docdir/
xz -9 %buildroot%docdir/IPv6-ChangeLog

# Install README_FILES.
rm -rf %buildroot%config_directory/README_FILES
mkdir -p %buildroot%docdir/README_FILES
ln -rsnf %buildroot%docdir/README_FILES %buildroot%config_directory/

# Install README.ALT
install -pm644 %_buildaltdir/README.ALT-ru_RU.utf8 %buildroot%docdir/

touch %buildroot%config_directory/{access,aliases,canonical,relocated,transport,virtual}.{cdb,db}

# syslog.d
mkdir -pm700 %buildroot%_sysconfdir/syslog.d
ln -s %ROOT/dev/log %buildroot%_sysconfdir/syslog.d/%name

# Chrooted environment
touch %buildroot%ROOT%_sysconfdir/{localtime,hosts,services,{host,nsswitch,resolv}.conf}
mksock %buildroot%ROOT/dev/log

# Remove sendmail-common files
rm %buildroot%_bindir/{mailq,newaliases}

### RUNTIME SCRIPTS ###

%pre
/usr/sbin/groupadd -r -f %setgid_group
/usr/sbin/groupadd -r -f %mail_owner
/usr/sbin/groupadd -r -f %default_privs
/usr/sbin/groupadd -r -f %mail_admin
/usr/sbin/useradd -r -n -g %name -d %ROOT -s /dev/null -c %name %name >/dev/null 2>&1 ||:
/usr/sbin/useradd -r -n -g %default_privs -d /dev/null -s /dev/null -c %default_privs %default_privs >/dev/null 2>&1 ||:

rm -f %restart_flag
if [ $1 -ge 2 ]; then
	SYSTEMCTL=systemctl
	if sd_booted && $SYSTEMCTL --version >/dev/null 2>&1; then
		$SYSTEMCTL is-active %name.service >/dev/null 2>&1 &&
		$SYSTEMCTL stop %name.service &&
		touch %restart_flag ||:
	else
		%_initdir/%name status >/dev/null 2>&1 &&
		%_initdir/%name stop &&
		touch %restart_flag ||:
	fi
	if [ ! -f %daemon_directory/postqueue/postqueue -a \
	       -f %command_directory/postqueue -a \
	     ! -L %command_directory/postqueue ]; then
		mkdir -pm755 %daemon_directory/postqueue &&
		cp -pf %command_directory/postqueue %daemon_directory/postqueue/
	fi
	/usr/sbin/control-dump %name postqueue
fi

oua=/usr/sbin/update-alternatives
if [ -x "$oua" ]; then
	"$oua" --remove aliases %config_directory/aliases >/dev/null 2>&1 ||:
fi

%post
if [ $1 -eq 1 ]; then
	chkconfig --add %name
else
	chkconfig %name resetpriorities
	SYSTEMCTL=systemctl
	sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1 &&
		"$SYSTEMCTL" daemon-reload ||:
fi
rm -f %config_directory/{access,aliases,canonical,relocated,transport,virtual}.{,c}db
%_libexecdir/postfix/post-install \
	config_directory=%config_directory \
	daemon_directory=%daemon_directory \
	upgrade-package
if [ $1 -ge 2 ]; then
	ALIASES=%config_directory/aliases /usr/share/sendmail-common/rebuild_aliases
	%_sysconfdir/chroot.d/%name.all --force
	/usr/sbin/control-restore %name postqueue
else
	/usr/sbin/control %name local
	/usr/sbin/control postqueue public
fi

%preun
if [ $1 = 0 ]; then
	service %name condstop
	chkconfig --del %name
	rm -f %ROOT/lib/* %ROOT%_sysconfdir/* %ROOT/var/yp/binding/* \
		%ROOT/var/nis/NIS_COLD_START
fi

%if_with tls
%post tls
for n in smtp smtpd; do
      ln -snf "$n"-tls %daemon_directory/"$n"
done
sed -i 's/^#\(.*tls\)/\1/' %daemon_directory/%name-files
%_libexecdir/postfix/post-install upgrade-package

%preun tls
if [ $1 = 0 ]; then
	for n in smtp smtpd; do
	      ln -snf "$n"-std %daemon_directory/"$n"
	done
	sed -i 's/[^#]*tls/#&/' %daemon_directory/%name-files
fi
%endif #with tls

%triggerpostun -- sendmail, exim, %name <= 0:20010228
[ $1 = 0 ] || exit 0
ln -snf %name/aliases %_sysconfdir/aliases
%_sysconfdir/chroot.d/%name.all

%files -f %name.files
%config %config_directory/main.cf.dist
%config %_initdir/%name
%config(noreplace) %_sysconfdir/cron.daily/%name
%config %_sysconfdir/chroot.d/*
%_sysconfdir/aliases
%ghost %attr(644,root,root) %config(missingok) %verify(not md5 mtime size) %config_directory/*.db
%ghost %attr(644,root,root) %config(missingok) %verify(not md5 mtime size) %config_directory/*.cdb
%attr(-,root,root) %daemon_directory/lmtp
%attr(-,root,root) %daemon_directory/smtp
%attr(-,root,root) %daemon_directory/smtpd
%_unitdir/%name.service
%_rpmlibdir/%name.filetrigger
%_sysconfdir/syslog.d/%name
%_libdir/%libpostfix
%_libdir/%libpostfix_dict
%attr(700,root,root) %verify(not mode,group) %dir %daemon_directory/postqueue
%command_directory/postqueue
%dir %plugin_directory
%_bindir/qshape
%_bindir/rmail
%_mandir/man?/*
%exclude %_mandir/man1/*-*
%if_with tls
%exclude %_mandir/man?/*tls*
%endif #with tls

%doc %config_directory/README_FILES
%dir %docdir
%docdir/examples
%docdir/[A-Z]*
%if_with tls
%exclude %docdir/TLS_*
%endif # with tls

# Chrooted environment
%attr(644,root,root) %verify(not md5 mtime size) %ghost %ROOT%_sysconfdir/*
%attr(666,root,root) %ghost %ROOT/dev/log

%files test-tools
%_bindir/*-*
%_mandir/man1/*-*

%files html
%dir %docdir
%docdir/html

%if_with ldap
%files ldap
%dir %plugin_directory
%plugin_directory/dict_ldap.so
%endif #with ldap

%if_with mysql
%files mysql
%dir %plugin_directory
%plugin_directory/dict_mysql.so
%endif #with mysql

%if_with pcre
%files pcre
%dir %plugin_directory
%plugin_directory/dict_pcre.so
%endif #with pcre

%if_with pgsql
%files pgsql
%dir %plugin_directory
%plugin_directory/dict_pgsql.so
%endif #with pgsql

%if_with sasl
%if_with cyrus
%files cyrus
%dir %plugin_directory
%plugin_directory/xsasl_cyrus.so
%endif #with cyrus

%files dovecot
%dir %plugin_directory
%plugin_directory/xsasl_dovecot.so
%endif #with sasl

%if_with tls
%files tls
%_sbindir/postfix-generate-ssl-certificate
%_mandir/man8/*tls*
%dir %daemon_directory
%daemon_directory/*-tls
%daemon_directory/tlsmgr
%daemon_directory/tlsproxy
%dir %docdir
%docdir/TLS_*
%endif #with tls

%changelog
