Name: powdertoy
Version: 94.1
Release: alt1
Summary: Classic 'falling sand' physics sandbox game
Group: Games/Educational
Epoch: 1
License: GPL
Url: http://powdertoy.co.uk/
# GitHub https://github.com/FacialTurd/The-Powder-Toy/tags
Source: v%version.tar.gz
Obsoletes: powder

# Automatically added by buildreq on Mon Apr 22 2019
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel liblua5.1-devel libstdc++-devel pkg-config python-base python-module-pkg_resources python-modules python-modules-compiler python-modules-email python-modules-encodings python-modules-json sh4
BuildRequires: bzlib-devel flex gcc-c++ ghostscript-classic libSDL2-devel libfftw3-devel liblua5.1-compat-devel scons zlib-devel

%description
The Powder Toy is a desktop version of the classic 'falling sand'
physics sandbox game, it simulates air pressure and velocity as well as
heat!

%prep
%setup -n The-Powder-Toy-%version
# Hack out version update messge
sed -i 's/gameModel->AddNotification.*\("A new.*available.*update"\).*;/fprintf(stderr, "%%s\\n", \1);/g' src/gui/game/GameController.cpp

cat > %name.sh <<@@@
#!/bin/sh
test -d "\$HOME/.powdertoy" ||
{ rm -f "\$HOME/.powdertoy"; mkdir -p "\$HOME/.powdertoy/Brushes"; }
cd "\$HOME/.powdertoy" && \$0.bin
@@@

sed -i.lua51 's/lua5.1/lua/g' SConscript

%ifarch %e2k
# as of lcc 1.21.23
sed -i 's,-ftree-vectorize,,;s,-funsafe-loop-optimizations,,' SConscript*
%endif

cat > %name.desktop <<@@@
[Desktop Entry]
Name=The Powder Toy
Type=Application
Exec=%name
Icon=%name
Terminal=false
GenericName=Sandbox game
Categories=Game;Simulation;
Comment=%summary
@@@

%build
#convert -set filename:area '%%wx%%h' resources/powder.ico 'powder-%%[filename:area].png'
%ifarch x86_64
scons -j %__nprocs --lin --64bit
%else
%ifarch %ix86
scons -j %__nprocs --lin
%else
scons -j %__nprocs --lin --no-sse
%endif
%endif

# TODO this doesn't compile for build263
# --opengl

%install
# TODO MIME (it can install mime locally!)
install -D build/powder* %buildroot%_gamesbindir/%name.bin
install -m755 %name.sh %buildroot%_gamesbindir/%name
install -D %name.desktop %buildroot%_desktopdir/%name.desktop
#for N in powder-*.png; do
for N in resources/icon/new-unused/icon_*.png ; do
	install -D $N %buildroot%_iconsdir/hicolor/$(basename ${$##*_} .png)/apps/%name.png
done

%files
%doc README* TODO
%_gamesbindir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/*

%changelog
