#global __find_debuginfo_files %nil

%define rname qemu
%define _group vmusers
%define rulenum 90
%define _libexecdir /usr/libexec
%define _localstatedir /var

Name: pve-%rname
Version: 5.1.0
Release: alt6
Epoch: 1
Summary: QEMU CPU Emulator
License: GPL-1 and LGPLv2 and BSD
Group: Emulators
Requires: %name-system = %EVR %name-user = %EVR
Conflicts: %rname
URL: http://www.nongnu.org/qemu/

Source0: qemu-%version.tar.xz
Source2: qemu-kvm.control.in
Source4: qemu-kvm.rules
# qemu-kvm back compat wrapper
Source5: qemu-kvm.sh
# /etc/qemu/bridge.conf
Source12: bridge.conf

Source100: Logo.bmp

Patch100: qemu-3.0.1-uuid.patch

Patch10: 0001-block-block-copy-always-align-copied-region-to-clust.patch
Patch11: 0002-Revert-qemu-img-convert-Don-t-pre-zero-images.patch
Patch12: 0003-usb-fix-setup_len-init-CVE-2020-14364.patch
Patch13: 0001-PVE-Config-block-file-change-locking-default-to-off.patch
Patch14: 0002-PVE-Config-Adjust-network-script-path-to-etc-kvm.patch
Patch15: 0003-PVE-Config-set-the-CPU-model-to-kvm64-32-instead-of-.patch
Patch16: 0004-PVE-Config-ui-spice-default-to-pve-certificates.patch
Patch17: 0005-PVE-Config-smm_available-false.patch
Patch18: 0006-PVE-Config-glusterfs-no-default-logfile-if-daemonize.patch
Patch19: 0007-PVE-Config-rbd-block-rbd-disable-rbd_cache_writethro.patch
Patch20: 0008-PVE-Up-qmp-add-get_link_status.patch
Patch21: 0009-PVE-Up-glusterfs-allow-partial-reads.patch
Patch22: 0010-PVE-Up-qemu-img-return-success-on-info-without-snaps.patch
Patch23: 0011-PVE-Up-qemu-img-dd-add-osize-and-read-from-to-stdin-.patch
Patch24: 0012-PVE-Up-qemu-img-dd-add-isize-parameter.patch
Patch25: 0013-PVE-Up-qemu-img-dd-add-n-skip_create.patch
Patch26: 0014-PVE-virtio-balloon-improve-query-balloon.patch
Patch27: 0015-PVE-qapi-modify-query-machines.patch
Patch28: 0016-PVE-qapi-modify-spice-query.patch
Patch29: 0017-PVE-internal-snapshot-async.patch
Patch30: 0018-add-optional-buffer-size-to-QEMUFile.patch
Patch31: 0019-PVE-block-add-the-zeroinit-block-driver-filter.patch
Patch32: 0020-PVE-Add-dummy-id-command-line-parameter.patch
Patch33: 0021-PVE-Config-Revert-target-i386-disable-LINT0-after-re.patch
Patch34: 0022-PVE-Up-Config-file-posix-make-locking-optiono-on-cre.patch
Patch35: 0023-PVE-monitor-disable-oob-capability.patch
Patch36: 0024-PVE-Compat-4.0-used-balloon-qemu-4-0-config-size-fal.patch
Patch37: 0025-PVE-Allow-version-code-in-machine-type.patch
Patch38: 0026-PVE-Backup-add-vma-backup-format-code.patch
Patch39: 0027-PVE-Backup-add-backup-dump-block-driver.patch
Patch40: 0028-PVE-Backup-proxmox-backup-patches-for-qemu.patch
Patch41: 0029-PVE-Backup-pbs-restore-new-command-to-restore-from-p.patch
Patch42: 0030-PVE-Backup-avoid-coroutines-to-fix-AIO-freeze-cleanu.patch
Patch43: 0031-drive-mirror-add-support-for-sync-bitmap-mode-never.patch
Patch44: 0032-drive-mirror-add-support-for-conditional-and-always-.patch
Patch45: 0033-mirror-add-check-for-bitmap-mode-without-bitmap.patch
Patch46: 0034-mirror-switch-to-bdrv_dirty_bitmap_merge_internal.patch
Patch47: 0035-iotests-add-test-for-bitmap-mirror.patch
Patch48: 0036-mirror-move-some-checks-to-qmp.patch
Patch49: 0037-PVE-Backup-Add-dirty-bitmap-tracking-for-incremental.patch
Patch50: 0038-PVE-backup-rename-incremental-to-use-dirty-bitmap.patch
Patch51: 0039-PVE-fixup-pbs-restore-API.patch
Patch52: 0040-PVE-always-set-dirty-counter-for-non-incremental-bac.patch
Patch53: 0041-PVE-use-proxmox_backup_check_incremental.patch
Patch54: 0042-PVE-fixup-pbs-backup-add-compress-and-encrypt-option.patch
Patch55: 0043-PVE-Add-PBS-block-driver-to-map-backup-archives-into.patch
Patch56: 0044-PVE-add-query_proxmox_support-QMP-command.patch
Patch57: 0045-pbs-fix-missing-crypt-and-compress-parameters.patch
Patch58: 0046-PVE-handle-PBS-write-callback-with-big-blocks-correc.patch
Patch59: 0047-PVE-add-zero-block-handling-to-PBS-dump-callback.patch
Patch60: 0048-PVE-add-query-pbs-bitmap-info-QMP-call.patch
Patch61: 0049-PVE-redirect-stderr-to-journal-when-daemonized.patch
Patch62: 0050-PVE-Add-sequential-job-transaction-support.patch
Patch63: 0051-PVE-Backup-Use-a-transaction-to-synchronize-job-stat.patch
Patch64: 0052-PVE-Backup-Use-more-coroutines-and-don-t-block-on-fi.patch
Patch65: 0053-PVE-fix-and-clean-up-error-handling-for-create_backu.patch
Patch66: 0054-migration-block-dirty-bitmap-fix-larger-granularity-.patch
Patch67: 0055-PVE-Migrate-dirty-bitmap-state-via-savevm.patch
Patch68: 0056-migration-block-dirty-bitmap-migrate-other-bitmaps-e.patch
Patch69: 0057-cpu-add-Kunpeng-920-cpu-support.patch

ExclusiveArch: x86_64 aarch64
BuildRequires: acpica bzlib-devel glib2-devel flex libaio-devel libalsa-devel libcap-devel
BuildRequires: libcap-ng-devel libcurl-devel libfdt-devel libgnutls-devel libiscsi-devel libjpeg-devel
BuildRequires: liblzo2-devel libncurses-devel libnettle-devel libnuma-devel libpixman-devel libpng-devel ceph-devel
BuildRequires: libsasl2-devel libseccomp-devel libspice-server-devel libssh2-devel libusbredir-devel libxfs-devel
BuildRequires: makeinfo perl-Pod-Usage pkgconfig(glusterfs-api) pkgconfig(virglrenderer)
BuildRequires: libsystemd-devel ipxe-roms-qemu seavgabios seabios
#BuildRequires: librdmacm-devel libibverbs-devel libibumad-devel
BuildRequires: python3-module-sphinx
BuildRequires: libpve-backup-qemu-devel

%description
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.  QEMU has two operating modes:

* Full system emulation.  In this mode, QEMU emulates a full system
  (for example a PC), including a processor and various peripherials.
  It can be used to launch different Operating Systems without rebooting
  the PC or to debug system code.

* User mode emulation.  In this mode, QEMU can launch Linux processes
  compiled for one CPU on another CPU.  It can be used to launch the
  Wine Windows API emulator or to ease cross-compilation and
  cross-debugging.

As QEMU requires no host kernel patches to run, it is very safe and easy
to use.

%package common
Summary: QEMU CPU Emulator - common files
Group: Emulators
Requires(pre): control >= 0.7.2
Requires(pre): shadow-utils sysvinit-utils
Requires: seavgabios
Requires: seabios
Requires: ipxe-roms-qemu >= 1.0.0-alt4.git93acb5d
Requires: %name-img = %EVR
Requires: edk2-ovmf edk2-aarch64
Conflicts: %rname-common
Obsoletes: %name-aux < %EVR

%description common
QEMU is a fast processor emulator using dynamic translation to achieve
good emulation speed.
This package contains common files for qemu.

%package system
Summary: QEMU CPU Emulator - full system emulation
Group: Emulators
Requires: %name-common = %EVR pve-backup-client
Conflicts: %rname-system %rname-ivshmem-tools %rname-tools %rname-kvm-core

%description system
Full system emulation.  In this mode, QEMU emulates a full system
(for example a PC), including a processor and various peripherials.
It can be used to launch different Operating Systems without rebooting
the PC or to debug system code.

%package img
Summary: QEMU command line tool for manipulating disk images
Group: Emulators
Conflicts: %rname-img

%description img
This package provides a command line tool for manipulating disk images

%set_verify_elf_method fhs=relaxed

%prep
%setup -n %rname-%version

%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
%patch38 -p1
%patch39 -p1
%patch40 -p1
%patch41 -p1
%patch42 -p1
%patch43 -p1
%patch44 -p1
%patch45 -p1
%patch46 -p1
%patch47 -p1
%patch48 -p1
%patch49 -p1
%patch50 -p1
%patch51 -p1
%patch52 -p1
%patch53 -p1
%patch54 -p1
%patch55 -p1
%patch56 -p1
%patch57 -p1
%patch58 -p1
%patch59 -p1
%patch60 -p1
%patch61 -p1
%patch62 -p1
%patch63 -p1
%patch64 -p1
%patch65 -p1
%patch66 -p1
%patch67 -p1
%patch68 -p1
%patch69 -p1

%patch100 -p1

cp -f %SOURCE2 qemu-kvm.control.in

%build
export CFLAGS="%optflags"
# non-GNU configure
./configure \
	--target-list=x86_64-softmmu,aarch64-softmmu \
	--prefix=%_prefix \
	--sysconfdir=%_sysconfdir \
	--libdir=%_libdir \
	--mandir=%_mandir \
	--libexecdir=%_libexecdir \
	--localstatedir=%_localstatedir \
	--extra-cflags="%optflags" \
	--disable-werror \
        --audio-drv-list="alsa" \
        --disable-capstone \
        --disable-gtk \
        --disable-guest-agent \
        --disable-guest-agent-msi \
        --disable-libnfs \
        --disable-libxml2 \
        --disable-sdl \
        --disable-smartcard \
        --disable-strip \
        --disable-xen \
        --enable-virglrenderer \
        --enable-curl \
        --enable-glusterfs \
        --enable-gnutls \
        --disable-jemalloc \
        --enable-libiscsi \
        --enable-libusb \
        --enable-linux-aio \
        --enable-numa \
        --enable-rbd \
        --enable-seccomp \
        --enable-spice \
        --enable-usb-redir \
        --enable-virtfs \
        --enable-xfsctl

sed -i 's|^QEMU_CFLAGS=|QEMU_CFLAGS=-I$(SRC_PATH) |' config-host.mak

%make_build V=1

sed -i 's/@GROUP@/%_group/g' qemu-kvm.control.in

%install
%makeinstall_std
install -m755 pbs-restore %buildroot%_bindir/

%define docdir %_docdir/%name-%version
#mv %buildroot%_docdir/qemu
mkdir -p %buildroot%docdir
install -m644 LICENSE MAINTAINERS %buildroot%docdir/
rm -rf %buildroot%_docdir/qemu

install -m 0755 %SOURCE5 %buildroot%_bindir/qemu-kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/kvm
ln -r -s %buildroot%_bindir/qemu-kvm %buildroot%_bindir/qemu
ln -sf qemu.1.xz %buildroot%_man1dir/qemu-kvm.1.xz

install -m 0755 vma %buildroot%_bindir/vma

rm -f %buildroot%_bindir/check-*
rm -f %buildroot%_sysconfdir/udev/rules.d/*
rm -f %buildroot%_desktopdir/%rname.desktop
rm -rf %buildroot%_iconsdir

install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/udev/rules.d/%rulenum-%rname-kvm.rules
install -D -m 0755 %rname-kvm.control.in %buildroot%_controldir/kvm

# TODO:
# Install qemu-pr-helper service
#install -m 0644 contrib/systemd/qemu-pr-helper.service %buildroot%_unitdir/qemu-pr-helper.service
#install -m 0644 contrib/systemd/qemu-pr-helper.socket %buildroot%_unitdir/qemu-pr-helper.socket
# Install rules to use the bridge helper with libvirt's virbr0
install -D -m 0644 %SOURCE12 %buildroot%_sysconfdir/%name/bridge.conf

%if_enabled vnc_sasl
install -D -p -m 0644 qemu.sasl %buildroot%_sysconfdir/sasl2/%rname.conf
%endif

%find_lang %rname

rm -f %buildroot%_datadir/%rname/pxe*rom
rm -f %buildroot%_datadir/%rname/efi*rom
rm -f %buildroot%_datadir/%rname/vgabios*bin
rm -f %buildroot%_datadir/%rname/bios.bin
rm -f %buildroot%_datadir/%rname/bios-256k.bin
rm -f %buildroot%_datadir/%rname/s390-*.img
rm -f %buildroot%_datadir/%rname/openbios*
rm -f %buildroot%_datadir/%rname/u-boot*

for rom in e1000 ne2k_pci pcnet rtl8139 virtio eepro100 e1000e vmxnet3 ; do
  ln -r -s %buildroot%_datadir/ipxe/pxe-${rom}.rom %buildroot%_datadir/%rname/pxe-${rom}.rom
  ln -r -s %buildroot%_datadir/ipxe.efi/efi-${rom}.rom %buildroot%_datadir/%rname/efi-${rom}.rom
done

for bios in vgabios vgabios-cirrus vgabios-qxl vgabios-stdvga vgabios-vmware vgabios-virtio ; do
  ln -r -s %buildroot%_datadir/seavgabios/${bios}.bin %buildroot%_datadir/%rname/${bios}.bin
done

ln -r -s %buildroot%_datadir/seabios/{bios,bios-256k}.bin %buildroot%_datadir/%rname/

mkdir -p %buildroot%_datadir/pve-edk2-firmware
ln -sf ../OVMF/OVMF_CODE.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_CODE.fd
ln -sf ../OVMF/OVMF_VARS.fd %buildroot%_datadir/pve-edk2-firmware/OVMF_VARS.fd
ln -sf ../AAVMF/QEMU_EFI-pflash.raw %buildroot%_datadir/pve-edk2-firmware/AAVMF_CODE.fd
ln -sf ../AAVMF/vars-template-pflash.raw %buildroot%_datadir/pve-edk2-firmware/AAVMF_VARS.fd


%check
# Disabled on aarch64 where it fails with several errors.  Will
# investigate and fix when we have access to real hardware
#ifnarch aarch64
#make V=1 check
#endif

%pre common
%_sbindir/groupadd -r -f %_group
if [ -f %_controldir/qemu-kvm ];then
%pre_control qemu-kvm
mv -f /var/run/control/qemu-kvm /var/run/control/kvm
else
%pre_control kvm
fi

%post common
%post_control -s vmusers kvm

%files common
%dir %docdir/
%docdir/LICENSE
%docdir/MAINTAINERS
%_datadir/qemu
%_datadir/pve-edk2-firmware
%dir %_sysconfdir/%name
%_sysconfdir/udev/rules.d/%rulenum-%rname-kvm.rules
%_controldir/*
%if_enabled vnc_sasl
%config(noreplace) %_sysconfdir/sasl2/%rname.conf
%endif
%_man7dir/qemu-block-drivers.*
%_man7dir/qemu-qmp-ref.*
%_man7dir/qemu-cpu-models.*

%files system -f %rname.lang
%_bindir/elf2dmp
%_bindir/qemu*system*
%_bindir/vma
%_bindir/qemu-edid
%_bindir/qemu-storage-daemon
%_bindir/qemu-kvm
%_bindir/kvm
%_bindir/qemu
%_man1dir/qemu.*
%_man1dir/qemu-kvm.1*
%_bindir/ivshmem-client
%_bindir/ivshmem-server
%_bindir/pbs-restore
%attr(4710,root,vmusers) %_libexecdir/qemu-bridge-helper
%config(noreplace) %_sysconfdir/%name/bridge.conf
%_libexecdir/qemu-pr-helper
# TODO:
#%_bindir/qemu-pr-helper
#%_unitdir/qemu-pr-helper.service
#%_unitdir/qemu-pr-helper.socket
%_libexecdir/virtfs-proxy-helper
%_man1dir/virtfs-proxy-helper.*
%_libexecdir/virtiofsd
%_man1dir/virtiofsd.*

%files img
%_bindir/qemu-img
%_bindir/qemu-io
%_bindir/qemu-nbd
%_man1dir/qemu-img.1*
%_man8dir/qemu-nbd.8*

%changelog
