%define _unpackaged_files_terminate_build 1

%def_with check

Name: py
Version: 1.8.0
Release: alt2

Summary: Testing and distributed programming library
License: MIT
Group: Development/Tools
# Source-git: https://github.com/pytest-dev/py.git
Url: https://github.com/pytest-dev/py

Source: %name-%version.tar
Source2: move.list
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python2.7(setuptools_scm)
BuildRequires: python3(setuptools_scm)

%if_with check
BuildRequires: subversion
BuildRequires: subversion-server-common
BuildRequires: python2.7(apipkg)
BuildRequires: python2.7(decorator)
BuildRequires: python2.7(iniconfig)
BuildRequires: python2.7(jinja2)
BuildRequires: python2.7(pytest)
BuildRequires: python3(apipkg)
BuildRequires: python3(decorator)
BuildRequires: python3(iniconfig)
BuildRequires: python3(jinja2)
BuildRequires: python3(tox)
%endif

BuildArch: noarch
Requires: python-module-%name = %EVR

%define move_list %(echo `cat %SOURCE2`)

%description
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

%package -n python3-module-%name
Summary: Python 3 module of testing and distributed programming library
Group: Development/Python3

# The compiler package has been removed in Python 3
%add_python3_req_skip compiler
%py3_provides %move_list
%py3_requires apipkg
%py3_requires iniconfig

%description -n python3-module-%name
The %name lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains python module of %name lib.

%package -n python-module-%name
Summary: Python module of testing and distributed programming library
Group: Development/Python
Conflicts: %name
%py_provides %move_list
%py_requires apipkg
%py_requires iniconfig

%description -n python-module-%name
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

This package contains python module of %name lib.

%prep
%setup
%patch0 -p1

# remove bundled packages
rm -r py/_vendored_packages

rm -rf ../python3
cp -a . ../python3

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_build

pushd ../python3
%python3_build
popd

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_install

pushd ../python3
%python3_install
popd

# check the actual provides against predefined ones
set -o pipefail
PYTHONPATH="$(pwd)" python3 -c "import py, apipkg;\
assert py.__version__==\"%version\";\
modules=[ 'py.' + mod for mod in dir(py) if isinstance(getattr(py, mod), apipkg.ApiModule) ];\
print(*modules, sep='\n')" | sort > move.actual.list
set +o pipefail
cat %SOURCE2 | sort > move.expected.list
diff -y move.expected.list move.actual.list

%check
export LC_ALL=en_US.UTF-8
export PIP_NO_INDEX=YES
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export TOX_TESTENV_PASSENV='LC_ALL SETUPTOOLS_SCM_PRETEND_VERSION'
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}

sed -i '/\[testenv\]/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/py.test3 \{envbindir\}\/py.test\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/py.test' tox.ini
tox.py3 --sitepackages -p auto -o -v -r

%files -n python-module-%name
%doc AUTHORS CHANGELOG LICENSE *.rst
%python_sitelibdir/py/
%python_sitelibdir/py-*.egg-info/

%files -n python3-module-%name
%doc AUTHORS CHANGELOG LICENSE *.rst
%python3_sitelibdir/py/
%python3_sitelibdir/py-*.egg-info/

%changelog
