# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: pysol.spec,v 1.6 2006/02/25 20:04:16 eugene Exp $

Name: pysol
Version: 4.82
Release: alt12

Summary: PySol provides several solitaire card games
Summary(ru_RU.UTF-8): PySol предлагает коллекцию карточных пасьянсов

License: GPL
Group: Games/Cards
Packager: Igor Vlasenko <viy@altlinux.ru>
URL: http://www.oberhumer.com/opensource/pysol/

Source0: %name-%version.tar.bz2
Source1: %name-%version-src.tar.bz2
Source2: icons-%name.tar.bz2
Source3: pysol.desktop

Patch0: %name-fix.patch
Patch1: %name-nosplash.patch
Patch2: %name-nosound.patch
Patch3: %name-colorchooser.patch
Patch4: %name-tcltk8.6.patch

Conflicts: pysol-cardsets <= 4.40-alt1
Conflicts: pysol-music <= 4.40-alt1

BuildArchitectures: noarch

%add_python_req_skip acard actions gamedb help mfxtools mfxutil stats util pysolaudio
%add_python_req_skip pysolsoundserver
%add_python_compile_include %_gamesdatadir/%name

# Automatically added by buildreq on Wed Mar 30 2005 (-bi)
BuildRequires: python-base python-modules-compiler python-modules-encodings

%description
PySol has several solitaire card games, written in 100%% pure
Python. It has many features: unlimited undo and redo, load & save
games, player statistics, hint system, game plug-ins, and more!
Contains: klondike, freecel, spider, golf, etc.

%description -l ru_RU.UTF-8
PySol - коллекция свыше 200 пасьянсов, на 100%% написанных на Python.
Игра имеет большое количество возможностей: неограниченную отмену и повтор
хода, загрузку и сохранение игр, статистику игрока, систему подсказок,
подключаемые игры и так далее. Содержит игры klondike (косынка),
freecell, spider, golf и многие другие.

%prep
%setup -q -a 1
%patch0
%patch1
%patch2
%patch3
%patch4

%install
%make_install \
    prefix=%buildroot%prefix \
    mandir=%buildroot%_mandir \
    pkgdatadir=%buildroot%_gamesdatadir/%name \
    install-bin install-data install-man

find %buildroot -type f -print0 |
	xargs -r0 fgrep -l "%buildroot" |
	xargs -r perl -pi -e "s|%buildroot||g"

cp -rf %name-%version/src/*  %buildroot%_gamesdatadir/%name

install -d %buildroot%_gamesbindir
cat >%buildroot%_gamesbindir/%name.sh <<EOF
#!/bin/sh -e
cd %_gamesdatadir/%name
PYTHON=python
\$PYTHON ./pysol.py
EOF
chmod 755 %buildroot%_gamesbindir/%name.sh

# Menu support - used desktop file
# mkdir -p %buildroot{%_menudir,%_iconsdir,%_liconsdir,%_miconsdir}
# cat >%buildroot%_menudir/%name <<EOF
# ?package(%name): \
# needs=x11 \
# section=Amusement/Cards \
# title=PySOL \
# command="soundwrapper %_gamesbindir/%name.sh" \
# icon=%name.xpm \
# longtitle="All solitaire cards games"
# EOF
install -d %buildroot%_desktopdir
install -m 644 %SOURCE3 %buildroot%_desktopdir/%name.desktop

# icons
install -d %buildroot%_miconsdir
install -d %buildroot%_liconsdir
install -d %buildroot%_niconsdir
tar xjf %SOURCE2 
mv large/* %buildroot%_liconsdir
mv mini/* %buildroot%_miconsdir
mv pysol.xpm %buildroot%_niconsdir

(cd %buildroot%_gamesdatadir/%name
    find . -type f -name 'Makefile'  -print0|xargs -r0 rm -rfv
    find . -type f -name 'README*' -print0|xargs -r0 rm -rfv
    find . -type f -name '*.py?' -print0|xargs -r0 rm -rfv
)

%files
%_gamesbindir/%name.sh
%_gamesdatadir/%name
%_mandir/man?/*
%_desktopdir/%name.desktop
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%doc README
%exclude %_bindir/%name


%changelog
