%define oname ClientCookie

%def_with python3

Name: python-module-%oname
Version: 1.3.0
Release: alt1.2

Summary: Python module for handling HTTP cookies on the client side
Source0: %oname-%version.tar.gz
License: BSD
Group: Development/Python
Requires: python
Url: http://wwwsearch.sourceforge.net/ClientCookie
BuildRequires: python-devel python-module-setuptools
Provides: python-%oname
Obsoletes: python-%oname
BuildArch: noarch

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%description
ClientCookie is a Python module for handling HTTP cookies on the
client side, useful for accessing web sites that require cookies to be
set and then returned later. It also provides some other (optional)
useful stuff: HTTP-EQUIV and Refresh handling, automatic adding of the
Referer [sic] header and lazily-seek()able responses. These extras are
implemented using an extension that makes it easier to add new
functionality to urllib2. It has developed from a port of Gisle Aas'
Perl module HTTP::Cookies, from the [4]libwww-perl library.

%package -n python3-module-%oname
Summary: Python module for handling HTTP cookies on the client side
Group: Development/Python3
%add_python3_req_skip bsddb

%description -n python3-module-%oname
ClientCookie is a Python module for handling HTTP cookies on the
client side, useful for accessing web sites that require cookies to be
set and then returned later. It also provides some other (optional)
useful stuff: HTTP-EQUIV and Refresh handling, automatic adding of the
Referer [sic] header and lazily-seek()able responses. These extras are
implemented using an extension that makes it easier to add new
functionality to urllib2. It has developed from a port of Gisle Aas'
Perl module HTTP::Cookies, from the [4]libwww-perl library.

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install --record=INSTALLED_FILES

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files -f INSTALLED_FILES
%doc *.html *.txt

%if_with python3
%files -n python3-module-%oname
%doc *.html *.txt
%python3_sitelibdir/*
%endif

%changelog
