%define oname ExtensionClass
Name: python-module-%oname
Version: 4.3.0
Release: alt1.1
Summary: Metaclass for subclassable extension types
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/ExtensionClass/

# https://github.com/zopefoundation/ExtensionClass.git
Source: %name-%version.tar

BuildRequires: python-module-setuptools
BuildRequires: python-module-nose

%description
ExtensionClass:
This package provides a metaclass that allows classes implemented in
extension modules to be subclassed in Python. Unless you need
ExtensionClasses for legacy applications (e.g. Zope 2), you probably
want to use Python's new-style classes (available since Python 2.2).

ComputedAttribute:
This package provides a way to attach attributes to an ExtensionClass or
instance that are computed by calling a callable. This works very much
like property known from new-style classes, except that a
ComputedAttribute can also be attached to an instance and that it
honours ExtensionClass semantics (which is useful for retaining
Acquisition wrappers, for example).

MethodObject:
This package lets you attach additional "methods" to ExtensionClasses.
These "methods" are actually implemented by subclassing the
MethodObject.Method class and implementing the __call__ method there.
Instances of those classes will be bound to the instances they're
attached to and will receive that instance object as a first parameter
(after self).

%package tests
Summary: Tests for ExtensionClass, ComputedAttribute and MethodObject
Group: Development/Python
Requires: %name = %version-%release

%description tests
Tests for ExtensionClass, ComputedAttribute and MethodObject.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%python_build

%install
%python_install

%check
python setup.py test
nosetests

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests.*

%files tests
%python_sitelibdir/*/tests.*

%changelog
