%define oname OpenGL

%def_with python3

Name: python-module-%oname
Version: 3.1.1a1
Release: alt2

Summary: A Python module for interfacing with the OpenGL library
Summary(ru_RU.UTF-8): Расширение языка Python для работы с библиотекой OpenGL

Group: Development/Python
License: see license.txt
Url: http://pyopengl.sourceforge.net

Source: PyOpenGL-%version.tar
Patch: PyOpenGL-swig.patch
Patch1: %name.patch

BuildArch: noarch

%setup_python_module OpenGL

#add_python_req_skip WGL__init__
%py_requires OpenGL_accelerate

BuildPreReq: python-module-setuptools python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools python3-devel
%endif

%description
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n python3-module-%oname
Summary: A Python module for interfacing with the OpenGL library
Group: Development/Python3
%py3_requires OpenGL_accelerate
%add_python3_req_skip OpenGL.GLES3.OES

%description -n python3-module-%oname
OpenGL bindings for Python including support for GL extensions,
GLU, WGL, GLUT, GLE, and Tk

%package -n python3-module-%oname-tests
Summary: PyOpenGL tests
Group: Development/Python3
Requires: python3-module-%oname =  %EVR
%add_python3_req_skip pygame

%description -n python3-module-%oname-tests
PyOpenGL tests.

%package demo
Summary: PyOpenGL demo files
Group: Development/Python
Requires: %name = %EVR
%add_python_req_skip items win32ui

%description demo
Demo for PyOpenGL

%package doc
Summary: PyOpenGL documentation
Group: Development/Python
Requires: %name = %EVR

%description doc
PyOpenGL documentation

%package tests
Summary: PyOpenGL tests
Group: Development/Python
Requires: %name = %EVR

%description tests
PyOpenGL tests.

%package tk
Summary: %oname Python 2.x Tk widget
Group: Development/Python
Requires: %name = %EVR
%py_requires tkinter

%description tk
%oname Togl (Tk OpenGL widget) 1.6 support for Python 2.x.

%package -n python3-module-%oname-tk
Summary: %oname Python 3.x Tk widget
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires tkinter

%description -n python3-module-%oname-tk
%oname Togl (Tk OpenGL widget) 1.6 support for Python 3.x.

%prep
%setup -n PyOpenGL-%version

find tests/ -type f -name '*.py' -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python|' '{}' +

%if_with python3
rm -fR ../python3
cp -fR . ../python3
pushd ../python3
find tests -type f -name '*.py' -exec \
	sed -i 's|#!%_bindir/python|#!%_bindir/python3|' '{}' +
find tests -type f -name '*.py' -exec 2to3 -w -n '{}' +

# In Python 3.7 async is a keyword, and so we can't have a module named async
# https://github.com/mcfletch/pyopengl/issues/14
mv OpenGL/GL/SGIX/async.py OpenGL/GL/SGIX/async_.py

mv OpenGL/raw/GL/SGIX/async.py OpenGL/raw/GL/SGIX/async_.py

sed -i -e 's/from OpenGL.raw.GL.SGIX.async/from OpenGL.raw.GL.SGIX.async_/g' OpenGL/GL/SGIX/async_.py

popd
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install
touch tests/__init__.py
cp -fR tests %buildroot/%python_sitelibdir/%modulename/

%if_with python3
pushd ../python3
%python3_install
touch tests/__init__.py
cp -fR tests %buildroot/%python3_sitelibdir/%modulename/
popd
%endif

%files
%python_sitelibdir/*.egg-info
%python_sitelibdir/%modulename/
%exclude %python_sitelibdir/%modulename/tests
%exclude %python_sitelibdir/OpenGL/Tk

%files tests
%python_sitelibdir/%modulename/tests

%files tk
%python_sitelibdir/OpenGL/Tk

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%modulename/
%exclude %python3_sitelibdir/%modulename/tests
%exclude %python3_sitelibdir/OpenGL/Tk

%files -n python3-module-%oname-tests
%python3_sitelibdir/%modulename/tests

%files -n python3-module-%oname-tk
%python3_sitelibdir/OpenGL/Tk
%endif

%changelog
