%define oname SQLAlchemy

Name: python-module-%oname
Version: 1.2.15
Release: alt1

Summary: Python SQL toolkit and Object Relational Mapper
License: MIT
Group: Development/Python
Url: http://www.sqlalchemy.org/

Source: SQLAlchemy-%version.tar
%py_provides SQLAlchemy

# Make sure that at least the Python built-in sqlite driver
# is present (and can be used by SQLAlchemy--among other things--
# in various tests, like in the tests for sphinx).
Requires: python-modules-sqlite3

BuildPreReq: python-devel python-module-setuptools

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools

%description
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%package -n python3-module-%oname
Summary: Python 3 SQL toolkit and Object Relational Mapper
Group: Development/Python3
%py3_provides SQLAlchemy

# Make sure that at least the Python built-in sqlite driver
# is present (and can be used by SQLAlchemy--among other things--
# in various tests, like in the tests for sphinx).
Requires: python3-modules-sqlite3

%description -n python3-module-%oname
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%package -n python3-module-%oname-tests
Summary: Tests for SQLAlchemy (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.

%package tests
Summary: Tests for SQLAlchemy
Group: Development/Python
Requires: %name = %version-%release

%description tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.

%prep
%setup -n SQLAlchemy-%version

rm -rf ../python3
cp -a . ../python3

%build
%add_optflags -fno-strict-aliasing
%python_build


pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/*/testing

%files tests
%python_sitelibdir/*/testing

%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/testing

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/testing

%changelog
