%define _unpackaged_files_terminate_build 1

%define oname ZEO

%def_with python3
%def_enable check

Name: python-module-%oname
Version: 5.2.0
Release: alt2.qa1
Summary: ZEO provides a client-server storage implementation for ZODB
License: ZPL
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/ZEO

# https://github.com/zopefoundation/ZEO.git
Source: %name-%version.tar

Patch1: %oname-alt-build.patch

BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-zope.testing
BuildRequires: python-module-manuel
BuildRequires: python-module-transaction
BuildRequires: python-module-persistent
BuildRequires: python-module-zc.lockfile
BuildRequires: python-module-zconfig
BuildRequires: python-module-zdaemon
BuildRequires: python-module-zope.interface
BuildRequires: python2.7(concurrent) python2.7(trollius)
%if_enabled check
BuildRequires: python2.7(msgpack) python2.7(mock) python-module-ZODB-tests
BuildRequires: python2.7(random2) python2.7(zope.testrunner)
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-manuel
BuildRequires: python3-module-transaction
BuildRequires: python3-module-persistent
BuildRequires: python3-module-zc.lockfile
BuildRequires: python3-module-zconfig
BuildRequires: python3-module-zdaemon
BuildRequires: python3-module-zope.interface
%if_enabled check
BuildRequires: python3(msgpack) python3(mock) python3-module-ZODB-tests
BuildRequires: python3(random2) python3(zope.testrunner)
%endif
%endif

%py_requires ZODB persistent zc.lockfile ZConfig zdaemon zope.interface
%py_requires concurrent trollius

%description
ZEO is a client-server system for sharing a single storage among many
clients. When you use ZEO, the storage is opened in the ZEO server
process. Client programs connect to this process using a ZEO
ClientStorage. ZEO provides a consistent view of the database to all
clients. The ZEO client and server communicate using a custom RPC
protocol layered on top of TCP.

%package tests
Summary: Tests for ZEO
Group: Development/Python
Requires: %name = %EVR
%py_requires zope.testing ZODB.tests

%description tests
ZEO is a client-server system for sharing a single storage among many
clients. When you use ZEO, the storage is opened in the ZEO server
process. Client programs connect to this process using a ZEO
ClientStorage. ZEO provides a consistent view of the database to all
clients. The ZEO client and server communicate using a custom RPC
protocol layered on top of TCP.

This package contains tests for ZEO.

%if_with python3
%package -n python3-module-%oname
Summary: ZEO provides a client-server storage implementation for ZODB
Group: Development/Python3
%py3_requires ZODB persistent zc.lockfile ZConfig zdaemon zope.interface
%add_python3_req_skip ZODB.Transaction

%description -n python3-module-%oname
ZEO is a client-server system for sharing a single storage among many
clients. When you use ZEO, the storage is opened in the ZEO server
process. Client programs connect to this process using a ZEO
ClientStorage. ZEO provides a consistent view of the database to all
clients. The ZEO client and server communicate using a custom RPC
protocol layered on top of TCP.

%package -n python3-module-%oname-tests
Summary: Tests for ZEO
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires zope.testing ZODB.tests

%description -n python3-module-%oname-tests
ZEO is a client-server system for sharing a single storage among many
clients. When you use ZEO, the storage is opened in the ZEO server
process. Client programs connect to this process using a ZEO
ClientStorage. ZEO provides a consistent view of the database to all
clients. The ZEO client and server communicate using a custom RPC
protocol layered on top of TCP.

This package contains tests for ZEO.
%endif

%prep
%setup
%patch1 -p1

%if_with python3
rm -rf ../python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
mv $i $i.py3
done
popd
%endif

%python_install

%check
python setup.py test

%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.txt *.rst
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/tests.py*

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/tests.py*

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests.py*
%exclude %python3_sitelibdir/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests.py*
%python3_sitelibdir/*/*/*/tests.*
%endif

%changelog
