%define oname chai

%def_with python3

Name: python-module-%oname
Version: 1.1.2
Release: alt1
Summary: Easy to use mocking, stubbing and spying framework
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/chai

# https://github.com/agoragames/chai.git
Source: %name-%version.tar
BuildArch: noarch

#BuildPreReq: python-devel python-module-setuptools
#BuildPreReq: python-module-sphinx-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_provides %oname

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Wed Jan 27 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytest python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python3 python3-base python3-module-setuptools
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python-module-setuptools python3-module-pytest rpm-build-python3 time

%description
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

%package -n python3-module-%oname
Summary: Easy to use mocking, stubbing and spying framework
Group: Development/Python3
%py3_provides %oname
%add_findreq_skiplist %python3_sitelibdir/%oname/python2.py

%description -n python3-module-%oname
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

This package contains documentation for %oname.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx docs
ln -s ../objects.inv docs/source/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%make -C docs pickle
%make -C docs html

cp -fR docs/build/pickle %buildroot%python_sitelibdir/%oname/

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc CHANGELOG *.rst examples
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*

%if_with python3
%files -n python3-module-%oname
%doc CHANGELOG *.rst examples
%python3_sitelibdir/*
%endif

%changelog
