%define oname cryptography
%def_with python3

Name: python-module-%oname
Version: 2.6.1
Release: alt1

Summary: Cryptographic recipes and primitives to Python developers.

License: %asl
Group: Development/Python
Url: https://pypi.python.org/pypi/cryptography/
Packager: Vladimir Didenko <cow@altlinux.org>
# Source-url: https://pypi.python.org/packages/source/c/cryptography/%oname-%version.tar.gz
Source: %oname-%version.tar

BuildRequires(pre): rpm-build-python rpm-build-licenses
BuildRequires: libssl-devel python-module-cffi python-module-enum34 python-module-pyasn1 python-module-setuptools

%if_with python3
BuildRequires(pre): rpm-build-python3 python3-devel python3-module-cffi python3-module-setuptools
%endif

%py_requires cffi
%py_requires enum34

%setup_python_module %oname

%description
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.


%if_with python3
%package -n python3-module-%oname
Summary: Cryptographic recipes and primitives to Python developers (Python 3).
Group: Development/Python3
%py3_requires cffi

%description -n python3-module-%oname
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.
%endif


%prep
%setup -n %oname-%version

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd

%filter_from_requires /python3[(]cryptography.hazmat.bindings._commoncrypto[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._constant_time[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._openssl[)]/d
%filter_from_requires /python3[(]cryptography.hazmat.bindings._padding[)]/d
%endif

%files
%doc AUTHORS.rst  CHANGELOG.rst  CONTRIBUTING.rst  README.rst
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-*
%endif

%changelog
